/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.dataset.DatasetException;
import thredds.server.dataset.TdsRequestedDataset;
import thredds.server.wms.ThreddsLayer;
import thredds.server.wms.ThreddsScalarLayer;
import thredds.server.wms.ThreddsVectorLayer;
import thredds.server.wms.config.WmsDetailedConfig;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import uk.ac.rdg.resc.edal.cdm.CdmUtils;
import uk.ac.rdg.resc.edal.cdm.DataReadingStrategy;
import uk.ac.rdg.resc.edal.coverage.CoverageMetadata;
import uk.ac.rdg.resc.ncwms.controller.RequestParams;
import uk.ac.rdg.resc.ncwms.exceptions.WmsException;
import uk.ac.rdg.resc.ncwms.util.WmsUtils;
import uk.ac.rdg.resc.ncwms.wms.Dataset;
import uk.ac.rdg.resc.ncwms.wms.Layer;
import uk.ac.rdg.resc.ncwms.wms.VectorLayer;

public class ThreddsDataset
implements Dataset {
    private static final Logger log = LoggerFactory.getLogger(ThreddsDataset.class);
    private final String urlPath;
    private final String title;
    private final Map<String, ThreddsScalarLayer> scalarLayers = new LinkedHashMap<String, ThreddsScalarLayer>();
    private final Map<String, ThreddsVectorLayer> vectorLayers = new LinkedHashMap<String, ThreddsVectorLayer>();

    private ThreddsDataset(String urlPath, GridDataset gridDataset, WmsDetailedConfig wmsConfig) throws IOException {
        this.urlPath = urlPath;
        this.title = gridDataset.getTitle();
        NetcdfDataset ncDataset = (NetcdfDataset)gridDataset.getNetcdfFile();
        DataReadingStrategy drStrategy = CdmUtils.getOptimumDataReadingStrategy((NetcdfDataset)ncDataset);
        Collection ccm = CdmUtils.readCoverageMetadata((GridDataset)gridDataset);
        for (CoverageMetadata cm : ccm) {
            GridDatatype gdt = gridDataset.findGridDatatype(cm.getId());
            ThreddsScalarLayer tsl = ThreddsScalarLayer.getNewLayer(cm, gdt, drStrategy, this, wmsConfig);
            this.scalarLayers.put(tsl.getName(), tsl);
        }
        List vectorLayersColl = WmsUtils.findVectorLayers(this.scalarLayers.values());
        for (VectorLayer vecLayer : vectorLayersColl) {
            ThreddsVectorLayer tdsVecLayer = new ThreddsVectorLayer(vecLayer);
            tdsVecLayer.setLayerSettings(wmsConfig.getSettings(tdsVecLayer));
            this.vectorLayers.put(vecLayer.getId(), tdsVecLayer);
        }
    }

    private ThreddsDataset(String urlPath, GridDataset gd, List<String> layers, WmsDetailedConfig wmsConfig) {
        this.urlPath = urlPath;
        this.title = gd.getTitle();
        NetcdfDataset ncDataset = (NetcdfDataset)gd.getNetcdfFile();
        DataReadingStrategy drStrategy = CdmUtils.getOptimumDataReadingStrategy((NetcdfDataset)ncDataset);
        for (String layer : layers) {
            GridDatatype gdt = gd.findGridDatatype(layer);
            CoverageMetadata cm = CdmUtils.readCoverageMetadata((GridDatatype)gdt);
            ThreddsScalarLayer tsl = ThreddsScalarLayer.getNewLayer(cm, gdt, drStrategy, this, wmsConfig);
            this.scalarLayers.put(tsl.getName(), tsl);
        }
        List vectorLayersColl = WmsUtils.findVectorLayers(this.scalarLayers.values());
        for (VectorLayer vecLayer : vectorLayersColl) {
            ThreddsVectorLayer tdsVecLayer = new ThreddsVectorLayer(vecLayer);
            tdsVecLayer.setLayerSettings(wmsConfig.getSettings(tdsVecLayer));
            this.vectorLayers.put(vecLayer.getId(), tdsVecLayer);
        }
    }

    public String getId() {
        return this.urlPath;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDatasetPath() {
        return this.urlPath;
    }

    public DateTime getLastUpdateTime() {
        return new DateTime();
    }

    public ThreddsLayer getLayerById(String layerId) {
        ThreddsLayer layer = this.scalarLayers.get(layerId);
        if (layer == null) {
            layer = this.vectorLayers.get(layerId);
        }
        return layer;
    }

    public Set<Layer> getLayers() {
        LinkedHashSet<Layer> layerSet = new LinkedHashSet<Layer>();
        layerSet.addAll(this.scalarLayers.values());
        layerSet.addAll(this.vectorLayers.values());
        return layerSet;
    }

    public String getCopyrightStatement() {
        return "";
    }

    public String getMoreInfoUrl() {
        return "";
    }

    public boolean isReady() {
        return true;
    }

    public boolean isLoading() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public Exception getException() {
        return null;
    }

    public boolean isDisabled() {
        return false;
    }

    static ThreddsDataset getThreddsDatasetForRequest(String request, GridDataset gridDataset, TdsRequestedDataset reqDataset, WmsDetailedConfig wmsConfig, RequestParams params) throws IOException, DatasetException, WmsException {
        ThreddsDataset tdsds = null;
        if (request.equals("GetLegendGraphic") && params.getString("LAYER") == null) {
            return null;
        }
        if (params.getString("LAYERS") == null && params.getString("LAYER") == null && params.getString("LAYERNAME") == null) {
            tdsds = new ThreddsDataset(reqDataset.getPath(), gridDataset, wmsConfig);
        } else {
            String layers = params.getString("LAYERS");
            if (layers == null) {
                layers = params.getString("LAYER");
            }
            if (layers == null) {
                layers = params.getString("LAYERNAME");
            }
            List<String> requestedLayers = ThreddsDataset.getLayerComponents(gridDataset, layers);
            tdsds = new ThreddsDataset(reqDataset.getPath(), gridDataset, requestedLayers, wmsConfig);
        }
        return tdsds;
    }

    private static List<String> getLayerComponents(GridDataset gd, String layer) {
        ArrayList<String> layers = new ArrayList<String>();
        GridDatatype grid = gd.findGridDatatype(layer);
        if (grid == null) {
            List grids = gd.getGrids();
            Iterator gridsIt = grids.iterator();
            while (gridsIt.hasNext() && layers.size() < 2) {
                GridDatatype g = (GridDatatype)gridsIt.next();
                VariableDS var = g.getVariable();
                Attribute stdName = var.findAttributeIgnoreCase("standard_name");
                if (stdName != null) {
                    if (!ThreddsDataset.isComponent(layer, stdName.getStringValue())) continue;
                    layers.add(var.getFullName());
                    continue;
                }
                Attribute longName = var.findAttributeIgnoreCase("long_name");
                if (longName != null) {
                    if (!ThreddsDataset.isComponent(layer, longName.getStringValue())) continue;
                    layers.add(var.getFullName());
                    continue;
                }
                if (!ThreddsDataset.isComponent(layer, var.getFullName())) continue;
                layers.add(var.getFullName());
            }
        } else {
            layers.add(layer);
        }
        return layers;
    }

    static boolean isComponent(String layerName, String varAtt) {
        if (varAtt.contains("eastward_") || varAtt.contains("northward_")) {
            String[] tokens = layerName.split("_");
            StringBuilder sb = new StringBuilder();
            if (tokens.length == 1) {
                sb.append(tokens[0] + "\\b");
            } else {
                sb.append(tokens[0] + "\\B");
                for (int i = 1; i < tokens.length - 1; ++i) {
                    sb.append(".*\\B" + tokens[i] + "\\B");
                }
                sb.append(".*\\B" + tokens[tokens.length - 1] + "\\b");
            }
            Pattern pattern = Pattern.compile(sb.toString());
            Matcher matcher = pattern.matcher(varAtt);
            return matcher.find();
        }
        return varAtt.contains("u-component of " + layerName) || varAtt.contains("v-component of " + layerName);
    }
}

