/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.DatasetHandler;
import thredds.util.ThreddsConfigReader;

public final class ThreddsConfig {
    private static Logger log = LoggerFactory.getLogger((String)"serverStartup");
    private static ThreddsConfigReader reader;
    private static List<String> catalogRoots;
    private static List<String> contentRootList;

    public static void init(String filename) {
        reader = new ThreddsConfigReader(filename, log);
        catalogRoots = new ArrayList<String>();
        contentRootList = new ArrayList<String>();
        for (String location : reader.getRootList("catalogRoot")) {
            catalogRoots.add(location);
            log.info("ThreddsConfig: adding catalogRoot = " + location);
        }
        for (String location : reader.getElementList("contentRoots", "contentRoot")) {
            contentRootList.add(location);
            log.info("ThreddsConfig: adding contentRoot [" + location + "].");
        }
        for (String className : reader.getRootList("datasetSource")) {
            DatasetHandler.registerDatasetSource(className);
        }
    }

    static List<String> getCatalogRoots() {
        return Collections.unmodifiableList(catalogRoots);
    }

    public static List<String> getContentRootList() {
        return Collections.unmodifiableList(contentRootList);
    }

    public static String get(String paramName, String defValue) {
        return reader.get(paramName, defValue);
    }

    public static boolean hasElement(String paramName) {
        return reader.hasElement(paramName);
    }

    public static boolean getBoolean(String paramName, boolean defValue) {
        return reader.getBoolean(paramName, defValue);
    }

    public static long getBytes(String paramName, long defValue) {
        return reader.getBytes(paramName, defValue);
    }

    public static int getInt(String paramName, int defValue) {
        return reader.getInt(paramName, defValue);
    }

    public static int getSeconds(String paramName, int defValue) {
        return reader.getSeconds(paramName, defValue);
    }
}

