/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import thredds.server.catalog.ConfigCatalog;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.FeatureCollection;

public class DataRoot {
    private String path;
    private String dirLocation;
    private DatasetScan scan;
    private FeatureCollection featCollection;
    private boolean cache = true;

    DataRoot(FeatureCollection featCollection) {
        this.setPath(featCollection.getPath());
        this.featCollection = featCollection;
        this.dirLocation = featCollection.getTopDirectoryLocation();
        this.show();
    }

    DataRoot(DatasetScan scan) {
        this.setPath(scan.getPath());
        this.scan = scan;
        this.dirLocation = scan.getScanLocation();
        this.show();
    }

    DataRoot(String path, String dirLocation) {
        this.setPath(path);
        this.dirLocation = dirLocation;
        this.scan = null;
        this.show();
    }

    private void setPath(String path) {
        this.path = path;
    }

    private void show() {
    }

    public String getPath() {
        return this.path;
    }

    public String getDirLocation() {
        return this.dirLocation;
    }

    public DatasetScan getDatasetScan() {
        return this.scan;
    }

    public FeatureCollection getFeatureCollection() {
        return this.featCollection;
    }

    public boolean isCache() {
        return this.cache;
    }

    public String toString() {
        return this.path;
    }

    public String toString2() {
        return this.path + "," + this.dirLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataRoot root = (DataRoot)o;
        return this.path.equals(root.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String getFileLocationFromRequestPath(String path) {
        if (this.scan != null) {
            return DataRoot.getFileLocationFromRequestPath(path, this.scan.getPath(), this.scan.getScanLocation());
        }
        if (this.featCollection != null) {
            return DataRoot.getFileLocationFromRequestPath(path, this.featCollection.getPath(), this.featCollection.getTopDirectoryLocation());
        }
        return DataRoot.getFileLocationFromRequestPath(path, this.getPath(), this.getDirLocation());
    }

    public static String getFileLocationFromRequestPath(String reqPath, String rootPath, String rootLocation) {
        if (reqPath == null) {
            return null;
        }
        if (reqPath.length() == 0) {
            return null;
        }
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if (!reqPath.startsWith(rootPath)) {
            return null;
        }
        String locationReletive = reqPath.substring(rootPath.length());
        if (locationReletive.startsWith("/")) {
            locationReletive = locationReletive.substring(1);
        }
        if (!locationReletive.endsWith("/")) {
            locationReletive = locationReletive + "/";
        }
        String scanDir = ConfigCatalog.translateAlias((String)rootLocation);
        return locationReletive.length() > 1 ? scanDir + "/" + locationReletive : scanDir;
    }
}

