/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.dataservice;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.server.ncss.dataservice.FeatureDatasetService;
import thredds.servlet.DatasetHandler;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;

@Service
public class FeatureDatasetServiceImpl
implements FeatureDatasetService {
    @Override
    public FeatureDataset findDatasetByPath(HttpServletRequest req, HttpServletResponse res) throws IOException {
        return this.findDatasetByPath(req, res, req.getPathInfo());
    }

    @Override
    public FeatureDataset findDatasetByPath(HttpServletRequest req, HttpServletResponse res, String datasetPath) throws IOException {
        GridDataset fd = null;
        InvDatasetFeatureCollection ftCollection = DatasetHandler.getFeatureCollection(req, res, datasetPath);
        if (ftCollection != null) {
            FeatureType type = ftCollection.getDataType();
            if (type == FeatureType.GRID) {
                fd = DatasetHandler.openGridDataset(req, res, datasetPath);
            }
            if (type.isPointFeatureType()) {
                fd = ftCollection.getFeatureDataset();
            }
        } else {
            NetcdfFile ncfile = DatasetHandler.getNetcdfFile(req, res, datasetPath);
            if (ncfile != null) {
                Set<NetcdfDataset.Enhance> enhance = Collections.unmodifiableSet(EnumSet.of(NetcdfDataset.Enhance.CoordSystems, NetcdfDataset.Enhance.ConvertEnums));
                fd = FeatureDatasetFactoryManager.wrap((FeatureType)FeatureType.ANY, (NetcdfDataset)NetcdfDataset.wrap((NetcdfFile)ncfile, enhance), null, (Formatter)new Formatter(System.err));
            }
        }
        return fd;
    }
}

