/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.validation;

import java.text.ParseException;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.validation.TimeParamsConstraint;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.TimeDuration;

public class TimeParamsValidator
implements ConstraintValidator<TimeParamsConstraint, NcssParamsBean> {
    public void initialize(TimeParamsConstraint constraintAnnotation) {
    }

    public boolean isValid(NcssParamsBean params, ConstraintValidatorContext constraintValidatorContext) {
        constraintValidatorContext.disableDefaultConstraintViolation();
        String time = params.getTime();
        String time_window = params.getTime_window();
        if (time != null) {
            boolean isValid = this.validateISOString(time, "{thredds.server.ncSubset.validation.param.time}", constraintValidatorContext);
            if (time_window != null) {
                try {
                    new TimeDuration(time_window);
                }
                catch (ParseException pe) {
                    isValid = false;
                    constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.param.time_window}").addConstraintViolation();
                }
            }
            params.setHasValidTime(isValid);
            return isValid;
        }
        String time_start = params.getTime_start();
        String time_end = params.getTime_end();
        String time_duration = params.getTime_duration();
        if (time_start == null && time_end == null && time_duration == null) {
            return true;
        }
        boolean isValid = true;
        if (!this.hasValidDateRange(time_start, time_end, time_duration)) {
            constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.time.range}").addConstraintViolation();
            isValid = false;
        } else {
            Date end;
            Date start;
            if (time_start != null) {
                isValid = this.validateISOString(time_start, "{thredds.server.ncSubset.validation.param.time_start}", constraintValidatorContext);
            }
            if (time_end != null) {
                isValid &= this.validateISOString(time_end, "{thredds.server.ncSubset.validation.param.time_end}", constraintValidatorContext) && isValid;
            }
            if (time_duration != null) {
                try {
                    new TimeDuration(time_duration);
                }
                catch (ParseException pe) {
                    isValid = false;
                    constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.param.time_duration}").addConstraintViolation();
                }
            }
            if (isValid && time_start != null && time_end != null && (start = this.isoString2Date(time_start)).after(end = this.isoString2Date(time_end))) {
                isValid = false;
                constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.start_gt_end}").addConstraintViolation();
            }
        }
        params.setHasValidDateRange(isValid);
        return isValid;
    }

    private boolean hasValidDateRange(String time_start, String time_end, String time_duration) {
        if (null == time_start && null == time_end && null == time_duration) {
            return false;
        }
        if (null != time_start && null != time_end) {
            return true;
        }
        if (null != time_start && null != time_duration) {
            return true;
        }
        return null != time_end && null != time_duration;
    }

    private boolean validateISOString(String isoString, String msg, ConstraintValidatorContext constraintValidatorContext) {
        if ("present".equals(isoString)) {
            return true;
        }
        boolean isValid = true;
        Date date = null;
        try {
            date = this.isoString2Date(isoString);
        }
        catch (IllegalArgumentException iea) {
            isValid = false;
            constraintValidatorContext.buildConstraintViolationWithTemplate(msg).addConstraintViolation();
        }
        return isValid;
    }

    private Date isoString2Date(String isoString) {
        if ("present".equals(isoString)) {
            return new Date();
        }
        CalendarDate cd = CalendarDateFormatter.isoStringToCalendarDate((Calendar)Calendar.getDefault(), (String)isoString);
        return new Date(cd.getMillis());
    }
}

