/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.core.StandardServices;
import thredds.servlet.ThreddsConfig;

public class AllowedServices {
    private Map<ServiceType, AllowedService> allowed = new HashMap<ServiceType, AllowedService>();

    public AllowedServices() {
        this.allowed.put(ServiceType.CdmRemote, new AllowedService(StandardServices.cdmRemote, true));
        this.allowed.put(ServiceType.DAP4, new AllowedService(StandardServices.dap4, true));
        this.allowed.put(ServiceType.OPENDAP, new AllowedService(StandardServices.opendap, true));
        this.allowed.put(ServiceType.Resolver, new AllowedService(StandardServices.latest, true));
        this.allowed.put(ServiceType.NetcdfSubset, new AllowedService(StandardServices.ncss, ThreddsConfig.getBoolean("NetcdfSubsetService.allow", true)));
        this.allowed.put(ServiceType.WMS, new AllowedService(StandardServices.wms, ThreddsConfig.getBoolean("WMS.allow", true)));
        this.allowed.put(ServiceType.WCS, new AllowedService(StandardServices.wcs, ThreddsConfig.getBoolean("WCS.allow", true)));
        this.allowed.put(ServiceType.ISO, new AllowedService(StandardServices.iso, ThreddsConfig.getBoolean("NCISO.isoAllow", true)));
        this.allowed.put(ServiceType.UDDC, new AllowedService(StandardServices.uddc, ThreddsConfig.getBoolean("NCISO.uddcAllow", true)));
        this.allowed.put(ServiceType.NCML, new AllowedService(StandardServices.ncml, ThreddsConfig.getBoolean("NCISO.ncmlAllow", true)));
    }

    public boolean isAllowed(ServiceType type) {
        AllowedService s = this.allowed.get(type);
        return s == null || s.allowed;
    }

    public Service getStandardService(ServiceType type) {
        AllowedService s = this.allowed.get(type);
        return s == null ? null : s.ss.getService();
    }

    public List<String> getDisallowedServices(Catalog catalog) {
        ArrayList<String> disallowedServices = new ArrayList<String>();
        for (Service s : catalog.getServices()) {
            this.checkService(s, disallowedServices);
        }
        return disallowedServices;
    }

    private void checkService(Service service, List<String> disallowedServices) {
        if (service.getType() == ServiceType.Compound) {
            for (Service nested : service.getNestedServices()) {
                this.checkService(nested, disallowedServices);
            }
        } else if (!this.isAllowed(service.getType())) {
            disallowedServices.add(service.getName());
        }
    }

    private class AllowedService {
        StandardServices ss;
        boolean allowed;

        private AllowedService(StandardServices ss, boolean allowed) {
            this.ss = ss;
            this.allowed = allowed;
        }
    }
}

