/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.core.ConfigCatalogManager;
import thredds.core.DataRoot;
import thredds.core.DatasetHandler;
import thredds.core.RestrictedAccessConfigListener;
import thredds.filesystem.MFileOS7;
import thredds.inventory.MFile;
import thredds.inventory.bdb.MetadataManager;
import thredds.server.admin.DebugController;
import thredds.server.catalog.ConfigCatalog;
import thredds.server.catalog.DatasetScan;
import thredds.server.config.TdsContext;
import thredds.servlet.PathMatcher;
import thredds.util.TdsPathUtils;
import thredds.util.filesource.FileSource;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.util.StringUtil2;

public final class DataRootHandler
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(DataRootHandler.class);
    private static Logger logCatalogInit = LoggerFactory.getLogger((String)(DataRootHandler.class.getName() + ".catalogInit"));
    private static Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    private static DataRootHandler singleton = null;
    private static final String ERROR = "*** ERROR ";
    public static final boolean debug = false;
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private PathMatcher pathMatcher;
    @Autowired
    private ConfigCatalogManager ccManager;
    private List<ConfigListener> configListeners = new ArrayList<ConfigListener>();
    volatile boolean isReinit = false;

    public static void setInstance(DataRootHandler drh) {
        if (singleton != null) {
            log.warn("setInstance(): Singleton already set: ignoring call.");
            return;
        }
        singleton = drh;
    }

    public static DataRootHandler getInstance() {
        if (singleton == null) {
            logCatalogInit.error("*** ERROR getInstance(): Called without setInstance() having been called.");
            throw new IllegalStateException("setInstance() must be called first.");
        }
        return singleton;
    }

    private DataRootHandler(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    private DataRootHandler() {
    }

    @Resource(name="dataRootLocationAliasExpanders")
    public void setDataRootLocationAliasExpanders(Map<String, String> aliases) {
        for (Map.Entry<String, String> entry : aliases.entrySet()) {
            ConfigCatalog.addAlias((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void afterPropertiesSet() {
        File file;
        this.registerConfigListener(new RestrictedAccessConfigListener());
        FileSource fileSource = this.tdsContext.getPublicDocFileSource();
        if (fileSource != null && (file = fileSource.getFile("")) != null) {
            ConfigCatalog.addAlias((String)"content", (String)StringUtils.cleanPath((String)file.getPath()));
        }
        this.ccManager = new ConfigCatalogManager();
        this.ccManager.initCatalogs();
        this.makeDebugActions();
        DatasetHandler.makeDebugActions();
        DataRootHandler.setInstance(this);
    }

    public boolean registerConfigListener(ConfigListener cl) {
        if (cl == null) {
            return false;
        }
        if (this.configListeners.contains(cl)) {
            return false;
        }
        return this.configListeners.add(cl);
    }

    public boolean unregisterConfigListener(ConfigListener cl) {
        if (cl == null) {
            return false;
        }
        return this.configListeners.remove(cl);
    }

    public synchronized void reinit() {
        this.isReinit = true;
        for (ConfigListener cl : this.configListeners) {
            cl.configStart();
        }
        logCatalogInit.info("\n**************************************\n**************************************\nStarting TDS config catalog reinitialization\n[" + CalendarDate.present() + "]");
        MetadataManager.closeAll();
        this.pathMatcher = new PathMatcher();
        DatasetHandler.reinit();
        this.ccManager = new ConfigCatalogManager();
        this.ccManager.initCatalogs();
        this.isReinit = false;
        logCatalogInit.info("\n**************************************\n**************************************\nDone with TDS config catalog reinitialization\n[" + CalendarDate.present() + "]");
    }

    public String findDataRootLocation(String path) {
        DataRoot dataRoot;
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return (dataRoot = (DataRoot)this.pathMatcher.match(path)) == null ? null : dataRoot.getDirLocation();
    }

    private DataRoot findDataRoot(String fullpath) {
        if (fullpath.length() > 0 && fullpath.charAt(0) == '/') {
            fullpath = fullpath.substring(1);
        }
        return (DataRoot)this.pathMatcher.match(fullpath);
    }

    public DataRootMatch findDataRootMatch(HttpServletRequest req) {
        String spath = TdsPathUtils.extractPath(req, null);
        if (spath.length() > 0 && spath.startsWith("/")) {
            spath = spath.substring(1);
        }
        return this.findDataRootMatch(spath);
    }

    public DataRootMatch findDataRootMatch(String spath) {
        DataRoot dataRoot;
        if (spath.startsWith("/")) {
            spath = spath.substring(1);
        }
        if ((dataRoot = this.findDataRoot(spath)) == null) {
            return null;
        }
        DataRootMatch match = new DataRootMatch();
        match.rootPath = dataRoot.getPath();
        match.remaining = spath.substring(match.rootPath.length());
        if (match.remaining.startsWith("/")) {
            match.remaining = match.remaining.substring(1);
        }
        match.dirLocation = dataRoot.getDirLocation();
        match.dataRoot = dataRoot;
        return match;
    }

    public boolean hasDataRootMatch(String path) {
        DataRoot dataRoot;
        if (path.length() > 0 && path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((dataRoot = this.findDataRoot(path)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("hasDataRootMatch(): no DatasetScan for " + path);
            }
            return false;
        }
        return true;
    }

    public MFile getFileFromRequestPath(String path) {
        DataRoot reqDataRoot;
        if (path.length() > 0 && path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((reqDataRoot = this.findDataRoot(path)) == null) {
            return null;
        }
        String location = reqDataRoot.getFileLocationFromRequestPath(path);
        try {
            return new MFileOS7(location);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Catalog getCatalog(String path, URI baseURI) throws IOException {
        if (path == null) {
            return null;
        }
        String workPath = path;
        if (workPath.startsWith("/")) {
            workPath = workPath.substring(1);
        }
        boolean reread = false;
        ConfigCatalog catalog = this.ccManager.getStaticCatalog(workPath);
        if (catalog != null) {
            CalendarDate expiresDateType = catalog.getExpires();
            if (expiresDateType != null && expiresDateType.getMillis() < System.currentTimeMillis()) {
                reread = true;
            }
        } else {
            reread = this.ccManager.isStaticCatalogNotInCache(workPath);
        }
        if (catalog == null) {
            catalog = this.makeDynamicCatalog(workPath, baseURI);
        }
        return catalog;
    }

    private Catalog makeDynamicCatalog(String path, URI baseURI) throws IOException {
        Catalog cat;
        DataRootMatch match;
        String workPath = path;
        if (!path.endsWith("/catalog.xml") && !path.endsWith("/latest.xml")) {
            return null;
        }
        int pos = workPath.lastIndexOf("/");
        if (pos >= 0) {
            workPath = workPath.substring(0, pos);
        }
        if ((match = this.findDataRootMatch(workPath)) == null) {
            return null;
        }
        if (match.dataRoot.getFeatureCollection() != null) {
            boolean isLatest = path.endsWith("/latest.xml");
            if (isLatest) {
                return match.dataRoot.getFeatureCollection().makeLatest(match.remaining, path, baseURI);
            }
            return match.dataRoot.getFeatureCollection().makeCatalog(match.remaining, path, baseURI);
        }
        if (path.endsWith("/latest.xml")) {
            return null;
        }
        DatasetScan dscan = match.dataRoot.getDatasetScan();
        if (log.isDebugEnabled()) {
            log.debug("makeDynamicCatalog(): Calling makeCatalogForDirectory( " + baseURI + ", " + path + ").");
        }
        if (null == (cat = dscan.makeCatalogForDirectory(path, baseURI))) {
            log.error("makeDynamicCatalog(): makeCatalogForDirectory failed = " + workPath);
        }
        return cat;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void showRoots(Formatter f) {
        Iterator iter = this.pathMatcher.iterator();
        while (iter.hasNext()) {
            DataRoot ds = (DataRoot)iter.next();
            f.format(" %s%n", ds.toString2());
        }
    }

    public void makeDebugActions() {
        DebugController.Category debugHandler = DebugController.find("catalogs");
        DebugController.Action act = new DebugController.Action("showStatic", "Show static catalogs"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doAction(DebugController.Event e) {
                StringBuilder sbuff = new StringBuilder();
                DataRootHandler dataRootHandler = DataRootHandler.this;
                synchronized (dataRootHandler) {
                    List<String> list = DataRootHandler.this.ccManager.getStaticCatalogPaths();
                    Collections.sort(list);
                    for (String catPath : list) {
                        ConfigCatalog cat = DataRootHandler.this.ccManager.getStaticCatalog(catPath);
                        sbuff.append(" catalog= ").append(catPath).append("; ");
                        String filename = StringUtil2.unescape((String)cat.getUriString());
                        sbuff.append(" from= ").append(filename).append("\n");
                    }
                }
                e.pw.println(StringUtil2.quoteHtmlContent((String)("\n" + sbuff.toString())));
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("showRoots", "Show data roots"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doAction(DebugController.Event e) {
                DataRootHandler dataRootHandler = DataRootHandler.this;
                synchronized (dataRootHandler) {
                    Iterator iter = DataRootHandler.this.pathMatcher.iterator();
                    while (iter.hasNext()) {
                        DataRoot ds = (DataRoot)iter.next();
                        e.pw.print(" <b>" + ds.getPath() + "</b>");
                        String url = DataRootHandler.this.tdsContext.getContextPath() + "/admin/dataDir/" + ds.getPath() + "/";
                        String type = ds.getDatasetScan() == null ? "root" : "scan";
                        e.pw.println(" for " + type + " directory= <a href='" + url + "'>" + ds.getDirLocation() + "</a> ");
                    }
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("getRoots", "Check data roots"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doAction(DebugController.Event e) {
                DataRootHandler dataRootHandler = DataRootHandler.this;
                synchronized (dataRootHandler) {
                    e.pw.print("<pre>\n");
                    Iterator iter = DataRootHandler.this.pathMatcher.iterator();
                    boolean ok = true;
                    while (iter.hasNext()) {
                        DataRoot ds = (DataRoot)iter.next();
                        if (ds.getDirLocation() == null) continue;
                        try {
                            File f = new File(ds.getDirLocation());
                            if (f.exists()) continue;
                            e.pw.print("MISSING on dir = " + ds.getDirLocation() + " for path = " + ds.getPath() + "\n");
                            ok = false;
                        }
                        catch (Throwable t) {
                            e.pw.print("ERROR on dir = " + ds.getDirLocation() + " for path = " + ds.getPath() + "\n");
                            e.pw.print(t.getMessage() + "\n");
                            ok = false;
                        }
                    }
                    if (ok) {
                        e.pw.print("ALL OK\n");
                    }
                    e.pw.print("</pre>\n");
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("reinit", "Reinitialize"){

            @Override
            public void doAction(DebugController.Event e) {
                try {
                    singleton.reinit();
                    e.pw.println("reinit ok");
                }
                catch (Exception e1) {
                    e.pw.println("Error on reinit " + e1.getMessage());
                    log.error("Error on reinit " + e1.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
    }

    public static interface ConfigListener {
        public void configStart();

        public void configEnd();

        public void configCatalog(Catalog var1);

        public void configDataset(Dataset var1);
    }

    public static class DataRootMatch {
        String rootPath;
        String remaining;
        String dirLocation;
        DataRoot dataRoot;
    }
}

