/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import java.io.IOException;
import java.net.URI;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.core.ConfigCatalogHtmlWriter;
import thredds.server.catalogservice.CatalogServiceUtils;
import thredds.server.catalogservice.Command;
import thredds.server.catalogservice.RemoteCatalogRequest;
import thredds.server.config.HtmlConfig;
import thredds.server.config.TdsContext;
import thredds.servlet.HtmlWriter;
import thredds.servlet.ThreddsConfig;

public class RemoteCatalogServiceController2 {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private HtmlWriter htmlWriter;
    @Autowired
    private HtmlConfig htmlConfig;

    @RequestMapping(value={"**"})
    protected ModelAndView handleAll(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            boolean allowRemote = ThreddsConfig.getBoolean("CatalogServices.allowRemote", false);
            if (!allowRemote) {
                response.sendError(403, "Catalog services not supported for remote catalogs.");
                return null;
            }
            if (request.getServletPath().equals("/remoteCatalogValidation.html")) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                this.htmlConfig.addHtmlConfigInfoToModel(model);
                return new ModelAndView("/thredds/server/catalogservice/validationForm", model);
            }
            BindingResult bindingResult = CatalogServiceUtils.bindAndValidateRemoteCatalogRequest(request);
            if (bindingResult.hasErrors()) {
                StringBuilder msg = new StringBuilder("Bad request");
                List oeList = bindingResult.getAllErrors();
                for (ObjectError e : oeList) {
                    msg.append(": ").append(e.getDefaultMessage() != null ? e.getDefaultMessage() : e.toString());
                }
                this.log.info("handleRequestInternal(): " + msg);
                response.sendError(400, msg.toString());
                return null;
            }
            RemoteCatalogRequest catalogServiceRequest = (RemoteCatalogRequest)bindingResult.getTarget();
            URI uri = catalogServiceRequest.getCatalogUri();
            CatalogBuilder builder = new CatalogBuilder();
            Catalog catalog = builder.buildFromURI(uri);
            if (builder.hasFatalError() || catalog == null) {
                Formatter f = new Formatter();
                f.format("Error reading catalog '%s' err=%s%n", uri, builder.getErrorMessage());
                this.log.debug(f.toString());
                response.sendError(400, f.toString());
                return null;
            }
            String mess = builder.getErrorMessage();
            if (mess.length() > 0) {
                System.out.printf(" parse Messages = %s%n", builder.getErrorMessage());
            }
            response.setHeader("Validate", "OK");
            ConfigCatalogHtmlWriter writer = new ConfigCatalogHtmlWriter(this.htmlWriter, this.htmlConfig, this.tdsContext.getContextPath());
            if (catalogServiceRequest.getCommand().equals((Object)Command.SHOW)) {
                writer.writeCatalog(request, response, catalog, false);
                return null;
            }
            if (catalogServiceRequest.getCommand().equals((Object)Command.SUBSET)) {
                String datasetId = catalogServiceRequest.getDataset();
                Dataset dataset = catalog.findDatasetByID(datasetId);
                if (dataset == null) {
                    String msg = "Did not find dataset [" + HtmlUtils.htmlEscape((String)datasetId) + "] in catalog [" + uri + "].";
                    this.log.info("handleRequestInternal(): " + msg);
                    response.sendError(400, msg);
                    return null;
                }
                if (catalogServiceRequest.isHtmlView()) {
                    writer.showDataset(uri.toString(), dataset, request, response, false);
                    return null;
                }
                Catalog subsetCat = catalog.subsetCatalogOnDataset(dataset);
                return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)subsetCat);
            }
            if (catalogServiceRequest.getCommand().equals((Object)Command.VALIDATE)) {
                return CatalogServiceUtils.constructValidationMessageModelAndView(uri, builder.getValidationMessage(), this.htmlConfig);
            }
            String msg = "Unsupported request command [" + (Object)((Object)catalogServiceRequest.getCommand()) + "].";
            this.log.error("handleRequestInternal(): " + msg + " -- NOTE: Should have been caught on input validation.");
            response.sendError(400, msg);
            return null;
        }
        catch (IOException e) {
            this.log.error("handleRequestInternal(): Trouble writing to response.", (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            this.log.error("handleRequestInternal(): Problem handling request.", e);
            if (!response.isCommitted()) {
                response.sendError(500);
            }
            return null;
        }
    }
}

