/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ServiceType;
import thredds.core.Viewer;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;

public class ViewerGodiva
implements Viewer {
    private static final Logger logger = LoggerFactory.getLogger(ViewerGodiva.class);

    @Override
    public boolean isViewable(Dataset ds) {
        Access access = ds.getAccess(ServiceType.WMS);
        return access != null && ThreddsConfig.getBoolean("WMS.allow", false);
    }

    @Override
    public String getViewerLinkHtml(Dataset ds, HttpServletRequest req) {
        Access access = ds.getAccess(ServiceType.WMS);
        if (access == null) {
            return null;
        }
        URI dataURI = access.getStandardUri();
        if (dataURI == null) {
            logger.warn("Godiva2Viewer access URL failed on {}", (Object)ds.getName());
            return null;
        }
        try {
            URI base = new URI(req.getRequestURL().toString());
            dataURI = base.resolve(dataURI);
        }
        catch (URISyntaxException e) {
            logger.warn("Godiva2Viewer URL=" + req.getRequestURL().toString(), (Throwable)e);
            return null;
        }
        return "<a href='" + ServletUtil.getContextPath() + "/godiva2/godiva2.html?server=" + dataURI.toString() + "'>Godiva2 (browser-based)</a>";
    }
}

