/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.admin;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.servlet.HtmlWriter;
import thredds.util.RequestForwardUtils;

@Controller
public class DirDisplayController {
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private HtmlWriter htmlWriter;

    @RequestMapping(value={"/admin/**"})
    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String path = req.getServletPath();
        if (path == null) {
            path = "";
        }
        if (path.startsWith("/admin")) {
            path = path.substring("/admin".length(), path.length());
        }
        if (path.contains("/../") || path.equals("..") || path.startsWith("../") || path.endsWith("/..")) {
            res.sendError(403, "Path cannot contain ..");
            return null;
        }
        File file = null;
        if (path.startsWith("/content/tdm")) {
            file = new File(this.tdsContext.getContentRootPath(), path.substring(9));
        } else if (path.startsWith("/content/")) {
            file = new File(this.tdsContext.getContentDirectory(), path.substring(9));
            if (!file.exists()) {
                file = this.tdsContext.getConfigFileSource().getFile(path.substring(9));
            }
        } else if (path.startsWith("/logs/")) {
            file = new File(this.tdsContext.getTomcatLogDirectory(), path.substring(6));
        } else if (path.startsWith("/dataDir/")) {
            String root = path.substring(9);
            file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(root);
        }
        if (file == null) {
            RequestForwardUtils.forwardRequest(path, this.tdsContext.getDefaultRequestDispatcher(), req, res);
            return null;
        }
        if (file.isDirectory()) {
            int i = this.htmlWriter.writeDirectory(res, file, path);
            int status = i == 0 ? 404 : 200;
            return null;
        }
        return new ModelAndView("threddsFileView", "file", (Object)file);
    }
}

