/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import thredds.server.catalogservice.Command;
import thredds.server.catalogservice.LocalCatalogRequest;
import thredds.util.StringValidateEncodeUtils;

public class LocalCatalogRequestValidator
implements Validator {
    private boolean htmlView = false;

    public boolean isHtmlView() {
        return this.htmlView;
    }

    public void setHtmlView(boolean htmlView) {
        this.htmlView = htmlView;
    }

    public boolean supports(Class clazz) {
        return LocalCatalogRequest.class.equals((Object)clazz);
    }

    public void validate(Object obj, Errors e) {
        LocalCatalogRequest rcr = (LocalCatalogRequest)obj;
        String path = rcr.getPath();
        ValidationUtils.rejectIfEmpty((Errors)e, (String)"path", (String)"path.empty", (String)"No path given in request.");
        if (!StringValidateEncodeUtils.validPath(path)) {
            e.rejectValue("path", "path.notValidPath", "The \"path\" field must be a valid path.");
        }
        if (path != null) {
            if (this.htmlView && !path.endsWith(".html")) {
                e.rejectValue("path", "path.notHmlRequest", "The \"path\" [" + path + "] field must end in \".html\".");
            } else if (!this.htmlView && !path.endsWith(".xml")) {
                e.rejectValue("path", "path.notXmlRequest", "The \"path\" field must end in \".xml\".");
            }
        }
        ValidationUtils.rejectIfEmpty((Errors)e, (String)"command", (String)"command.empty");
        if (rcr.getCommand().equals((Object)Command.VALIDATE)) {
            e.rejectValue("command", "command.invalidRequest.VALIDATE", "The \"command\" field may not be VALIDATE.");
        }
        if (rcr.getCommand().equals((Object)Command.SUBSET)) {
            ValidationUtils.rejectIfEmpty((Errors)e, (String)"dataset", (String)"dataset.empty", (String)"No dataset specified in SUBSET request.");
        }
    }
}

