/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote.validation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import thredds.server.cdmremote.params.CdmrfQueryBean;
import thredds.server.cdmremote.validation.CdmrfQueryConstraint;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class CdmrfQueryValidator
implements ConstraintValidator<CdmrfQueryConstraint, CdmrfQueryBean> {
    private boolean isValid = true;

    public void initialize(CdmrfQueryConstraint constraint) {
    }

    public boolean isValid(CdmrfQueryBean queryBean, ConstraintValidatorContext context) {
        this.validate(queryBean, context);
        return this.isValid;
    }

    private void validate(CdmrfQueryBean queryBean, ConstraintValidatorContext context) {
        CdmrfQueryBean.RequestType reqType = queryBean.getRequestType();
        if (reqType == CdmrfQueryBean.RequestType.data) {
            this.parseVariablesForm(queryBean, context);
            this.parseSpatialExtentForm(queryBean, context);
            this.parseTemporalExtentForm(queryBean, context);
        } else {
            this.parseSpatialExtent(queryBean, context);
            this.parseTimeExtent(queryBean);
            if (queryBean.getSpatialSelection() == null && queryBean.getStn() != null) {
                queryBean.setSpatialSelection(CdmrfQueryBean.SpatialSelection.stns);
            }
        }
    }

    private void parseVariablesForm(CdmrfQueryBean queryBean, ConstraintValidatorContext context) {
        String variables = queryBean.getVariables();
        if (variables == null) {
            context.buildConstraintViolationWithTemplate("{thredds.server.cdmremote.validation.error.musthavevars}").addConstraintViolation();
            this.isValid = false;
            return;
        }
        if (variables.equalsIgnoreCase("all")) {
            queryBean.setVar(null);
        }
    }

    private void parseSpatialExtentForm(CdmrfQueryBean queryBean, ConstraintValidatorContext context) {
        String spatial = queryBean.getSpatial();
        if (spatial == null) {
            context.buildConstraintViolationWithTemplate("{thredds.server.cdmremote.validation.error.musthavespatial}").addConstraintViolation();
            this.isValid = false;
            return;
        }
        if (spatial.equalsIgnoreCase("all")) {
            queryBean.setSpatialSelection(CdmrfQueryBean.SpatialSelection.all);
        } else if (spatial.equalsIgnoreCase("bb")) {
            queryBean.setSpatialSelection(CdmrfQueryBean.SpatialSelection.bb);
        } else if (spatial.equalsIgnoreCase("point")) {
            queryBean.setSpatialSelection(CdmrfQueryBean.SpatialSelection.point);
        } else if (spatial.equalsIgnoreCase("stns")) {
            queryBean.setSpatialSelection(CdmrfQueryBean.SpatialSelection.stns);
        }
        if (queryBean.getSpatialSelection() == CdmrfQueryBean.SpatialSelection.bb) {
            this.parseSpatialExtent(queryBean, context);
        } else if (queryBean.getSpatialSelection() == CdmrfQueryBean.SpatialSelection.point) {
            double lat = queryBean.parseLat("latitude", queryBean.getLatitude());
            double lon = queryBean.parseLon("longitude", queryBean.getLongitude());
            queryBean.setLatLonPoint((LatLonPoint)new LatLonPointImpl(lat, lon));
        }
    }

    private void parseSpatialExtent(CdmrfQueryBean queryBean, ConstraintValidatorContext context) {
        String bbox = queryBean.getBbox();
        String west = queryBean.getWest();
        String east = queryBean.getEast();
        String south = queryBean.getSouth();
        String north = queryBean.getNorth();
        if (bbox != null) {
            String[] s = bbox.split(",");
            if (s.length != 4) {
                context.buildConstraintViolationWithTemplate("{thredds.server.cdmremote.validation.error.bboxmusbevalid}").addConstraintViolation();
                this.isValid = false;
                return;
            }
            west = s[0];
            east = s[1];
            south = s[2];
            north = s[3];
        }
        if (west != null || east != null || south != null || north != null) {
            if (west == null || east == null || south == null || north == null) {
                context.buildConstraintViolationWithTemplate("{thredds.server.cdmremote.validation.error.missingedges}").addConstraintViolation();
                this.isValid = false;
                return;
            }
            double westd = queryBean.parseLon("west", west);
            double eastd = queryBean.parseLon("east", east);
            double southd = queryBean.parseLat("south", south);
            double northd = queryBean.parseLat("north", north);
            if (this.isValid) {
                queryBean.setLLBB(new LatLonRect((LatLonPoint)new LatLonPointImpl(southd, westd), (LatLonPoint)new LatLonPointImpl(northd, eastd)));
                queryBean.setSpatialSelection(CdmrfQueryBean.SpatialSelection.bb);
            }
        }
    }

    private void parseTemporalExtentForm(CdmrfQueryBean queryBean, ConstraintValidatorContext context) {
        String temporal = queryBean.getTemporal();
        if (temporal == null) {
            context.buildConstraintViolationWithTemplate("{thredds.server.cdmremote.validation.error.musthavetemporal}").addConstraintViolation();
            this.isValid = false;
            return;
        }
        if (temporal.equalsIgnoreCase("all")) {
            queryBean.setTemporalSelection(CdmrfQueryBean.TemporalSelection.all);
        } else if (temporal.equalsIgnoreCase("range")) {
            queryBean.setTemporalSelection(CdmrfQueryBean.TemporalSelection.range);
        } else if (temporal.equalsIgnoreCase("point")) {
            queryBean.setTemporalSelection(CdmrfQueryBean.TemporalSelection.point);
        }
        if (temporal.equalsIgnoreCase("range")) {
            try {
                this.parseTimeExtent(queryBean);
            }
            catch (Throwable t) {
                context.buildConstraintViolationWithTemplate("{thredds.server.cdmremote.validation.error.wrongtimerange}").addConstraintViolation();
                this.isValid = false;
            }
        } else if (temporal.equalsIgnoreCase("point")) {
            queryBean.setTimepoint(queryBean.parseDate("time", queryBean.getTime()));
        }
    }

    private void parseTimeExtent(CdmrfQueryBean queryBean) {
        DateType startDate = queryBean.parseDate("time_start", queryBean.getTime_start());
        DateType endDate = queryBean.parseDate("time_end", queryBean.getTime_end());
        TimeDuration duration = queryBean.parseW3CDuration("time_duration", queryBean.getTime_duration());
        if (startDate != null && endDate != null) {
            queryBean.setDateRange(new DateRange(startDate, endDate, null, null));
        } else if (startDate != null && duration != null) {
            queryBean.setDateRange(new DateRange(startDate, null, duration, null));
        } else if (endDate != null && duration != null) {
            queryBean.setDateRange(new DateRange(null, endDate, duration, null));
        }
        if (queryBean.getDateRange() != null) {
            queryBean.setTemporalSelection(CdmrfQueryBean.TemporalSelection.range);
        }
    }
}

