/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmvalidator;

import com.coverity.security.Escape;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.transform.XSLTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.server.cdmvalidator.CdmValidatorContext;
import thredds.servlet.UsageLog;
import thredds.util.ContentType;
import ucar.nc2.constants.CDM;
import ucar.nc2.dataset.NetcdfDatasetInfo;
import ucar.unidata.util.StringUtil2;

public class CdmValidatorController
extends AbstractController {
    private static Logger log = LoggerFactory.getLogger(CdmValidatorController.class);
    private CdmValidatorContext cdmValidatorContext;

    public void setCdmValidatorContext(CdmValidatorContext cdmValidatorContext) {
        this.cdmValidatorContext = cdmValidatorContext;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.info("handleRequestInternal(): " + UsageLog.setupRequestContext(request));
        String reqPath = request.getServletPath();
        if (reqPath == null) {
            log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(404, 0L));
            response.sendError(404);
            return null;
        }
        if (request.getMethod().equalsIgnoreCase("GET")) {
            if (reqPath.equals("/validate.html")) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("contextPath", request.getContextPath());
                model.put("servletPath", request.getServletPath());
                this.cdmValidatorContext.getHtmlConfig().addHtmlConfigInfoToModel(model);
                log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(200, -1L));
                return new ModelAndView("/thredds/server/cdmvalidator/cdmValidate", model);
            }
            if (reqPath.equals("/validateHelp.html")) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("contextPath", request.getContextPath());
                model.put("servletPath", request.getServletPath());
                this.cdmValidatorContext.getHtmlConfig().addHtmlConfigInfoToModel(model);
                log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(200, -1L));
                return new ModelAndView("/thredds/server/cdmvalidator/cdmValidateHelp", model);
            }
            if (reqPath.equals("/validate")) {
                this.doGet(request, response);
                return null;
            }
            log.info("handleRequestInternal(): Unsupported path [" + reqPath + "] - " + UsageLog.closingMessageForRequestContext(404, 0L));
            response.sendError(404);
            return null;
        }
        if (!request.getMethod().equalsIgnoreCase("POST")) return null;
        if (reqPath.equals("/validate")) {
            this.doPost(request, response);
            return null;
        }
        log.info("handleRequestInternal(): Unsupported path [" + reqPath + "] - " + UsageLog.closingMessageForRequestContext(404, 0L));
        response.sendError(404);
        return null;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        log.info("doGet(): " + UsageLog.setupRequestContext(req));
        String urlString = req.getParameter("URL");
        if (urlString == null) {
            log.info("doGet(): " + UsageLog.closingMessageForRequestContext(400, 0L));
            res.sendError(400, "Must have a URL parameter");
            return;
        }
        try {
            URI uri = new URI(urlString);
            urlString = uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            log.info("doGet(): " + UsageLog.closingMessageForRequestContext(400, 0L));
            res.sendError(400, "URISyntaxException on URU parameter");
            return;
        }
        String xml = req.getParameter("xml");
        boolean wantXml = xml != null && xml.equals("true");
        try {
            int len = this.showValidatorResults(res, urlString, wantXml);
            log.info("doGet(): URL = " + urlString);
            log.info("doGet(): " + UsageLog.closingMessageForRequestContext(200, len));
        }
        catch (Exception e) {
            log.info("doGet(): " + UsageLog.closingMessageForRequestContext(400, 0L));
            res.sendError(400, "Invalid input");
        }
        catch (Throwable e) {
            log.error("doGet(): Validator internal error", e);
            log.info("doGet(): " + UsageLog.closingMessageForRequestContext(500, 0L));
            res.sendError(500, "Validator internal error");
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        List fileItems;
        log.info("doPost(): " + UsageLog.setupRequestContext(req));
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
        if (!isMultipart) {
            log.info("doPost(): " + UsageLog.closingMessageForRequestContext(400, 0L));
            res.sendError(400);
            return;
        }
        ServletFileUpload upload = new ServletFileUpload(this.cdmValidatorContext.getFileuploadFileItemFactory());
        upload.setSizeMax(this.cdmValidatorContext.getMaxFileUploadSize());
        try {
            fileItems = upload.parseRequest(req);
        }
        catch (FileUploadException e) {
            log.info("doPost(): Validator FileUploadException", (Throwable)e);
            log.info("doPost(): " + UsageLog.closingMessageForRequestContext(400, 0L));
            if (!res.isCommitted()) {
                res.sendError(400);
            }
            return;
        }
        String username = null;
        boolean wantXml = false;
        for (FileItem item : fileItems) {
            if (!item.isFormField()) continue;
            if ("username".equals(item.getFieldName())) {
                username = item.getString();
            }
            if (!"xml".equals(item.getFieldName())) continue;
            wantXml = item.getString().equals("true");
        }
        for (FileItem item : fileItems) {
            if (item.isFormField()) continue;
            try {
                this.processUploadedFile(req, res, (DiskFileItem)item, username, wantXml);
                return;
            }
            catch (Exception e) {
                log.info("doPost(): Validator processUploadedFile", (Throwable)e);
                log.info("doPost(): " + UsageLog.closingMessageForRequestContext(400, 0L));
                res.sendError(400, e.getMessage());
            }
        }
    }

    private void processUploadedFile(HttpServletRequest req, HttpServletResponse res, DiskFileItem item, String username, boolean wantXml) throws Exception {
        if (username == null || username.length() == 0) {
            username = "none";
        }
        username = Escape.html((String)StringUtil2.filter((String)username, (String)"_"));
        String filename = Escape.html((String)item.getName());
        filename = StringUtil2.replace((String)filename, (String)"/", (String)"-");
        filename = StringUtil2.filter((String)filename, (String)".-_");
        File uploadedFile = new File(this.cdmValidatorContext.getCacheDir() + "/" + username + "/" + filename);
        uploadedFile.getParentFile().mkdirs();
        item.write(uploadedFile);
        int len = this.showValidatorResults(res, uploadedFile.getPath(), wantXml);
        if (this.cdmValidatorContext.isDeleteImmediately()) {
            try {
                uploadedFile.delete();
            }
            catch (Exception e) {
                log.error("processUploadedFile(): Uploaded File = " + uploadedFile.getPath() + " delete failed = " + e.getMessage());
            }
        }
        if (req.getRemoteUser() == null && username != null) {
            MDC.put((String)"userid", (String)username);
        }
        log.info("processUploadedFile(): Uploaded File = " + item.getName() + " sent to " + uploadedFile.getPath() + " size= " + uploadedFile.length());
        log.info("processUploadedFile(): " + UsageLog.closingMessageForRequestContext(200, len));
    }

    private int showValidatorResults(HttpServletResponse res, String location, boolean wantXml) throws Exception {
        try (NetcdfDatasetInfo info = new NetcdfDatasetInfo(location);){
            String infoString;
            if (wantXml) {
                infoString = info.writeXML();
                res.setContentLength(infoString.getBytes(CDM.utf8Charset).length);
                res.setContentType(ContentType.xml.getContentHeader());
            } else {
                Document xml = info.makeDocument();
                InputStream is = this.getXSLT();
                XSLTransformer transformer = new XSLTransformer(is);
                Document html = transformer.transform(xml);
                XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                infoString = fmt.outputString(html);
                res.setContentType(ContentType.html.getContentHeader());
            }
            res.setContentLength(infoString.getBytes(CDM.utf8Charset).length);
            ServletOutputStream out = res.getOutputStream();
            out.write(infoString.getBytes(CDM.utf8Charset));
            out.flush();
            int n = infoString.length();
            return n;
        }
    }

    private InputStream getXSLT() {
        Class<CdmValidatorController> c = CdmValidatorController.class;
        String resource = "/resources/xsl/cdmValidation.xsl";
        InputStream is = c.getResourceAsStream(resource);
        if (null == is) {
            log.error("getXSLT(): Cant load XSLT resource = " + resource);
        }
        return is;
    }
}

