/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.point;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.util.NcssRequestUtils;
import thredds.server.ncss.view.dsg.point.AbstractPointSubsetWriter;
import thredds.util.ContentType;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.util.xml.Parse;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.util.Format;

public class PointSubsetWriterXML
extends AbstractPointSubsetWriter {
    private final XMLStreamWriter staxWriter;

    public PointSubsetWriterXML(FeatureDatasetPoint fdPoint, NcssParamsBean ncssParams, OutputStream out) throws XMLStreamException, NcssException, IOException {
        super(fdPoint, ncssParams);
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.staxWriter = factory.createXMLStreamWriter(out, "UTF-8");
    }

    @Override
    public HttpHeaders getHttpHeaders(String datasetPath, boolean isStream) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (!isStream) {
            httpHeaders.set("Content-Location", datasetPath);
            String fileName = NcssRequestUtils.getFileNameForResponse(datasetPath, ".xml");
            httpHeaders.set("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        }
        httpHeaders.set("Content-Type", ContentType.xml.getContentHeader());
        return httpHeaders;
    }

    @Override
    public void writeHeader(PointFeature pf) throws XMLStreamException {
        this.staxWriter.writeStartDocument("UTF-8", "1.0");
        this.staxWriter.writeCharacters("\n");
        this.staxWriter.writeStartElement("pointFeatureCollection");
    }

    @Override
    public void writePoint(PointFeature pointFeat) throws Exception {
        EarthLocation loc = pointFeat.getLocation();
        this.staxWriter.writeCharacters("\n    ");
        this.staxWriter.writeStartElement("pointFeature");
        this.staxWriter.writeAttribute("date", CalendarDateFormatter.toDateTimeString((CalendarDate)pointFeat.getObservationTimeAsCalendarDate()));
        this.staxWriter.writeCharacters("\n        ");
        this.staxWriter.writeEmptyElement("location");
        this.staxWriter.writeAttribute("latitude", Format.dfrac((double)loc.getLatitude(), (int)3));
        this.staxWriter.writeAttribute("longitude", Format.dfrac((double)loc.getLongitude(), (int)3));
        if (!Double.isNaN(loc.getAltitude())) {
            this.staxWriter.writeAttribute("altitude", Format.dfrac((double)loc.getAltitude(), (int)0));
        }
        for (VariableSimpleIF wantedVar : this.wantedVariables) {
            this.staxWriter.writeCharacters("\n        ");
            this.staxWriter.writeStartElement("data");
            this.staxWriter.writeAttribute("name", wantedVar.getShortName());
            if (wantedVar.getUnitsString() != null) {
                this.staxWriter.writeAttribute("units", wantedVar.getUnitsString());
            }
            Array dataArray = pointFeat.getData().getArray(wantedVar.getShortName());
            String ss = dataArray.toString();
            Class elemType = dataArray.getElementType();
            if (elemType == String.class || elemType == Character.TYPE || elemType == StructureData.class) {
                ss = Parse.cleanCharacterData((String)ss);
            }
            this.staxWriter.writeCharacters(ss.trim());
            this.staxWriter.writeEndElement();
        }
        this.staxWriter.writeCharacters("\n    ");
        this.staxWriter.writeEndElement();
    }

    @Override
    public void writeFooter() throws XMLStreamException {
        this.staxWriter.writeCharacters("\n");
        this.staxWriter.writeEndElement();
        this.staxWriter.writeCharacters("\n");
        this.staxWriter.writeEndDocument();
        this.staxWriter.close();
    }
}

