/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.gridaspoint;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.exception.DateUnitException;
import thredds.server.ncss.exception.UnsupportedOperationException;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.view.gridaspoint.PointDataWriter;
import thredds.server.ncss.view.gridaspoint.PointDataWriterFactory;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.DiskCache2;
import ucar.unidata.geoloc.LatLonPoint;

public final class PointDataStream {
    private static Logger log = LoggerFactory.getLogger(PointDataStream.class);
    private final PointDataWriter pointDataWriter;

    public static PointDataStream factory(SupportedFormat supportedFormat, OutputStream outputStream, DiskCache2 diskCache) {
        return new PointDataStream(supportedFormat, outputStream, diskCache);
    }

    private PointDataStream(SupportedFormat supportedFormat, OutputStream outputStream, DiskCache2 diskCache) {
        this.pointDataWriter = PointDataWriterFactory.factory(supportedFormat, outputStream, diskCache);
    }

    public final boolean stream(GridDataset gds, LatLonPoint point, List<CalendarDate> wDates, Map<String, List<String>> groupedVars, Double vertCoord) throws DateUnitException, UnsupportedOperationException, InvalidRangeException {
        boolean allDone = false;
        ArrayList vars = new ArrayList();
        ArrayList<String> keys = new ArrayList<String>(groupedVars.keySet());
        for (String key : keys) {
            vars.addAll(groupedVars.get(key));
        }
        if (this.pointDataWriter.header(groupedVars, gds, wDates, this.getTimeDimAtts(gds), point, vertCoord)) {
            boolean allPointsRead = false;
            allPointsRead = this.pointDataWriter.write(groupedVars, gds, wDates, point, vertCoord);
            allDone = this.pointDataWriter.trailer() && allPointsRead;
        }
        return allDone;
    }

    private List<Attribute> getTimeDimAtts(GridDataset gds) {
        Attribute tLongName;
        Attribute tStdName;
        CoordinateAxis1DTime tAxis = null;
        List ggss = gds.getGridsets();
        Iterator it = ggss.iterator();
        while (tAxis == null && it.hasNext()) {
            GridDataset.Gridset gs = (GridDataset.Gridset)it.next();
            tAxis = gs.getGeoCoordSystem().getTimeAxis1D();
        }
        if (tAxis == null) {
            return null;
        }
        ArrayList<Attribute> timeAtts = new ArrayList<Attribute>();
        String timeUnitString = tAxis.getUnitsString();
        if (tAxis.getDataType() == DataType.STRING && tAxis.getUnitsString().equals("")) {
            CalendarDate startDate = tAxis.getCalendarDate(0);
            timeUnitString = "seconds since " + startDate.toString();
            timeAtts.add(new Attribute("units", timeUnitString));
        } else {
            Attribute tUnits = tAxis.findAttribute("units");
            if (tUnits != null) {
                timeAtts.add(tUnits);
            }
        }
        Attribute tCal = tAxis.findAttribute("calendar");
        if (tCal != null) {
            timeAtts.add(tCal);
        }
        if ((tStdName = tAxis.findAttribute("standard_name")) != null) {
            timeAtts.add(tStdName);
        }
        if ((tLongName = tAxis.findAttribute("long_name")) != null) {
            timeAtts.add(tLongName);
        }
        return timeAtts;
    }

    public final HttpHeaders getHttpHeaders(GridDataset gds, String pathInfo, Boolean isStream) {
        this.pointDataWriter.setHTTPHeaders(gds, pathInfo, isStream);
        return this.pointDataWriter.getResponseHeaders();
    }
}

