/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.InvalidDimensionException;
import opendap.dap.PrimitiveVector;
import opendap.servers.SDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.NcSDString;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;

public class NcSDCharArray
extends SDArray
implements HasNetcdfVariable {
    private static Logger log = LoggerFactory.getLogger(NcSDCharArray.class);
    private static final boolean debugRead = false;
    private static final boolean debugReadDetail = false;
    private Variable ncVar = null;
    private int strLen = 1;

    NcSDCharArray(Variable v) {
        super(Variable.getDAPName((Variable)v));
        this.ncVar = v;
        if (v.getRank() < 1) {
            throw new IllegalArgumentException("NcSDCharArray: rank must be > 1, var = " + v.getFullName());
        }
        List dims = v.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = (Dimension)dims.get(i);
            if (i < dims.size() - 1) {
                this.appendDim(dim.getLength(), dim.getShortName());
                continue;
            }
            this.strLen = dim.getLength();
        }
        this.addVariable((BaseType)new NcSDString(Variable.getDAPName((Variable)v), null));
    }

    @Override
    public Variable getVariable() {
        return this.ncVar;
    }

    public boolean read(String datasetName, Object specialO) throws IOException {
        Array a;
        boolean hasStride = false;
        try {
            int n = this.numDimensions();
            int[] origin = new int[n + 1];
            int[] shape = new int[n + 1];
            for (int i = 0; i < n; ++i) {
                origin[i] = this.getStart(i);
                shape[i] = this.getStop(i) - this.getStart(i) + 1;
                hasStride = hasStride || this.getStride(i) > 1;
            }
            origin[n] = 0;
            shape[n] = this.strLen;
            a = this.ncVar.read(origin, shape);
            if (hasStride) {
                ArrayList<Range> ranges = new ArrayList<Range>();
                for (int i = 0; i < n; ++i) {
                    int s = this.getStride(i);
                    if (s <= 1) continue;
                    ranges.add(new Range(0, shape[i], s));
                }
                ranges.add(null);
                a = a.section(ranges);
            }
        }
        catch (InvalidDimensionException e) {
            log.error("read char array", (Throwable)e);
            throw new IllegalStateException("NcSDCharArray InvalidDimensionException");
        }
        catch (InvalidRangeException e) {
            log.error("read char array", (Throwable)e);
            throw new IllegalStateException("NcSDCharArray InvalidRangeException");
        }
        this.setData(a);
        return false;
    }

    @Override
    public void setData(Array data) {
        PrimitiveVector pv = this.getPrimitiveVector();
        ArrayChar ca = (ArrayChar)data;
        ArrayChar.StringIterator siter = ca.getStringIterator();
        int nelems = siter.getNumElems();
        BaseTypePrimitiveVector btpv = (BaseTypePrimitiveVector)pv;
        btpv.setLength(nelems);
        for (int i = 0; i < nelems; ++i) {
            String val = siter.next();
            NcSDString ds = new NcSDString("", val);
            btpv.setValue(i, (BaseType)ds);
        }
        this.setRead(true);
    }

    @Override
    public void serialize(DataOutputStream sink, StructureData sdata, StructureMembers.Member m) throws IOException {
        this.setData(sdata.getArray(m));
        this.externalize(sink);
    }
}

