/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import thredds.server.wms.ThreddsDataset;
import thredds.server.wms.ThreddsLayer;
import thredds.server.wms.config.LayerSettings;
import thredds.server.wms.config.WmsDetailedConfig;
import ucar.nc2.Attribute;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import uk.ac.rdg.resc.edal.cdm.CdmUtils;
import uk.ac.rdg.resc.edal.cdm.DataReadingStrategy;
import uk.ac.rdg.resc.edal.cdm.PixelMap;
import uk.ac.rdg.resc.edal.coverage.CoverageMetadata;
import uk.ac.rdg.resc.edal.coverage.domain.Domain;
import uk.ac.rdg.resc.edal.coverage.domain.impl.HorizontalDomain;
import uk.ac.rdg.resc.edal.coverage.grid.HorizontalGrid;
import uk.ac.rdg.resc.edal.geometry.HorizontalPosition;
import uk.ac.rdg.resc.edal.util.Range;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidDimensionValueException;
import uk.ac.rdg.resc.ncwms.graphics.ColorPalette;
import uk.ac.rdg.resc.ncwms.wms.AbstractScalarLayer;

class ThreddsScalarLayer
extends AbstractScalarLayer
implements ThreddsLayer {
    private GridDatatype grid;
    private ThreddsDataset dataset;
    private List<DateTime> times;
    private DataReadingStrategy dataReadingStrategy;
    private LayerSettings layerSettings;

    public ThreddsScalarLayer(CoverageMetadata cm) {
        super(cm);
    }

    public List<List<Float>> readVerticalSection(DateTime dt, List<Double> list, Domain<HorizontalPosition> domain) throws InvalidDimensionValueException, IOException {
        List<Object> zIndices;
        int tIndex = this.findAndCheckTimeIndex(dt);
        if (list == null) {
            zIndices = Arrays.asList(-1);
        } else {
            zIndices = new ArrayList(list.size());
            for (Double el : list) {
                zIndices.add(this.findAndCheckElevationIndex(el));
            }
        }
        HorizontalGrid hg = CdmUtils.createHorizontalGrid((GridCoordSystem)this.grid.getCoordinateSystem());
        PixelMap pixelMap = new PixelMap(hg, domain);
        return CdmUtils.readVerticalSection(null, (GridDatatype)this.grid, (int)tIndex, zIndices, (PixelMap)pixelMap, (DataReadingStrategy)this.dataReadingStrategy, (int)((int)domain.size()));
    }

    public static ThreddsScalarLayer getNewLayer(CoverageMetadata cm, GridDatatype gdt, DataReadingStrategy drStrategy, ThreddsDataset ds, WmsDetailedConfig wmsConfig) {
        ThreddsScalarLayer tsl = new ThreddsScalarLayer(cm);
        tsl.setGridDatatype(gdt);
        tsl.setTimeValues(cm.getTimeValues());
        tsl.setDataReadingStrategy(drStrategy);
        tsl.setDataset(ds);
        tsl.setLayerSettings(wmsConfig.getSettings(tsl));
        return tsl;
    }

    public String getName() {
        return this.getId();
    }

    @Override
    public ThreddsDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(ThreddsDataset dataset) {
        this.dataset = dataset;
    }

    public void setGridDatatype(GridDatatype grid) {
        this.grid = grid;
    }

    public Chronology getChronology() {
        if (this.times == null || this.times.isEmpty()) {
            return null;
        }
        return this.times.get(0).getChronology();
    }

    public List<DateTime> getTimeValues() {
        return this.times;
    }

    public void setTimeValues(List<DateTime> timeValues) {
        this.times = timeValues;
    }

    public void setDataReadingStrategy(DataReadingStrategy dataReadingStrategy) {
        this.dataReadingStrategy = dataReadingStrategy;
    }

    public Float readSinglePoint(DateTime time, double elevation, HorizontalPosition xy) throws InvalidDimensionValueException, IOException {
        HorizontalDomain singlePoint = new HorizontalDomain(xy);
        return this.readHorizontalPoints(time, elevation, (Domain<HorizontalPosition>)singlePoint).get(0);
    }

    public List<Float> readHorizontalPoints(DateTime time, double elevation, Domain<HorizontalPosition> points) throws InvalidDimensionValueException, IOException {
        List horizontalPoints;
        int tIndex = this.findAndCheckTimeIndex(time);
        int zIndex = this.findAndCheckElevationIndex(elevation);
        HorizontalGrid hg = CdmUtils.createHorizontalGrid((GridCoordSystem)this.grid.getCoordinateSystem());
        PixelMap pixelMap = new PixelMap(hg, points);
        try {
            horizontalPoints = CdmUtils.readHorizontalPoints(null, (GridDatatype)this.grid, (int)tIndex, (int)zIndex, (PixelMap)pixelMap, (DataReadingStrategy)this.dataReadingStrategy, (int)((int)points.size()));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return horizontalPoints;
    }

    public List<Float> readTimeseries(List<DateTime> times, double elevation, HorizontalPosition xy) throws InvalidDimensionValueException, IOException {
        HorizontalGrid horizGrid = CdmUtils.createHorizontalGrid((GridCoordSystem)this.grid.getCoordinateSystem());
        ArrayList<Integer> tIndices = new ArrayList<Integer>(times.size());
        for (DateTime time : times) {
            tIndices.add(this.findAndCheckTimeIndex(time));
        }
        int zIndex = this.findAndCheckElevationIndex(elevation);
        return CdmUtils.readTimeseries(null, (GridDatatype)this.grid, (HorizontalGrid)horizGrid, tIndices, (int)zIndex, (HorizontalPosition)xy);
    }

    @Override
    public String getStandardName() {
        if (this.grid == null) {
            return null;
        }
        Attribute stdNameAtt = this.grid.findAttributeIgnoreCase("standard_name");
        if (stdNameAtt == null || stdNameAtt.getStringValue().trim().equals("")) {
            return null;
        }
        return stdNameAtt.getStringValue();
    }

    @Override
    public void setLayerSettings(LayerSettings layerSettings) {
        this.layerSettings = layerSettings;
    }

    public boolean isQueryable() {
        return this.layerSettings.isAllowFeatureInfo();
    }

    public boolean isIntervalTime() {
        return this.layerSettings.isIntervalTime();
    }

    public Range<Float> getApproxValueRange() {
        return this.layerSettings.getDefaultColorScaleRange();
    }

    public boolean isLogScaling() {
        return this.layerSettings.isLogScaling();
    }

    public ColorPalette getDefaultColorPalette() {
        return ColorPalette.get((String)this.layerSettings.getDefaultPaletteName());
    }

    public int getDefaultNumColorBands() {
        return this.layerSettings.getDefaultNumColorBands();
    }
}

