/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import thredds.server.wms.ThreddsLayer;
import thredds.server.wms.config.DatasetPathSettings;
import thredds.server.wms.config.LayerSettings;
import thredds.server.wms.config.StandardNameSettings;
import thredds.server.wms.config.WmsConfigException;
import ucar.nc2.units.SimpleUnit;
import uk.ac.rdg.resc.edal.util.Range;
import uk.ac.rdg.resc.edal.util.Ranges;

public class WmsDetailedConfig {
    private LayerSettings defaultSettings;
    private Map<String, StandardNameSettings> standardNames = new HashMap<String, StandardNameSettings>();
    private Map<String, DatasetPathSettings> datasetPaths = new HashMap<String, DatasetPathSettings>();

    private WmsDetailedConfig() {
    }

    public static WmsDetailedConfig fromFile(File configFile) throws IOException, WmsConfigException {
        return WmsDetailedConfig.fromInputStream(new FileInputStream(configFile));
    }

    public static WmsDetailedConfig fromInputStream(InputStream in) throws IOException, WmsConfigException {
        WmsDetailedConfig wmsConfig = new WmsDetailedConfig();
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setXMLReaderFactory((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
            builder.setExpandEntities(false);
            Document doc = builder.build(in);
            XPathExpression defaultSettingsExpression = XPathFactory.instance().compile("/wmsConfig/global/defaults", Filters.element(), null, new Namespace[]{Namespace.NO_NAMESPACE});
            Element defaultSettingsEl = (Element)defaultSettingsExpression.evaluateFirst((Object)doc);
            wmsConfig.defaultSettings = new LayerSettings(defaultSettingsEl);
            XPathExpression standardNamesExpression = XPathFactory.instance().compile("/wmsConfig/global/standardNames/standardName", Filters.element(), null, new Namespace[]{Namespace.NO_NAMESPACE});
            List standardNamesList = standardNamesExpression.evaluate((Object)doc);
            for (Element standardNameEl : standardNamesList) {
                StandardNameSettings sns = new StandardNameSettings(standardNameEl);
                wmsConfig.standardNames.put(sns.getStandardName(), sns);
            }
            XPathExpression datasetPathsExpression = XPathFactory.instance().compile("/wmsConfig/overrides/datasetPath", Filters.element(), null, new Namespace[]{Namespace.NO_NAMESPACE});
            List datasetPathsList = datasetPathsExpression.evaluate((Object)doc);
            for (Element datasetPathEl : datasetPathsList) {
                DatasetPathSettings pathSettings = new DatasetPathSettings(datasetPathEl);
                wmsConfig.datasetPaths.put(pathSettings.getPathSpec(), pathSettings);
            }
        }
        catch (IOException | JDOMException e) {
            throw new WmsConfigException((Exception)e);
        }
        return wmsConfig;
    }

    public LayerSettings getSettings(ThreddsLayer layer) {
        StandardNameSettings stdNameSettings;
        LayerSettings settings = new LayerSettings();
        String dsPath = layer.getDataset().getDatasetPath();
        DatasetPathSettings dpSettings = this.getBestDatasetPathMatch(dsPath);
        if (dpSettings != null) {
            LayerSettings pathDefaults;
            LayerSettings varSettings = dpSettings.getSettingsPerVariable().get(layer.getId());
            if (varSettings != null) {
                settings.replaceNullValues(varSettings);
            }
            if ((pathDefaults = dpSettings.getDefaultSettings()) != null) {
                settings.replaceNullValues(pathDefaults);
            }
        }
        if (layer.getStandardName() != null && (stdNameSettings = this.standardNames.get(layer.getStandardName())) != null) {
            boolean defaultColorScaleRangeUnset = settings.getDefaultColorScaleRange() == null;
            settings.replaceNullValues(stdNameSettings.getSettings());
            if (defaultColorScaleRangeUnset && stdNameSettings.getSettings().getDefaultColorScaleRange() != null) {
                Range<Float> newColorScaleRange = WmsDetailedConfig.convertUnits(stdNameSettings.getSettings().getDefaultColorScaleRange(), stdNameSettings.getUnits(), layer.getUnits());
                settings.setDefaultColorScaleRange(newColorScaleRange);
            }
        }
        settings.replaceNullValues(this.defaultSettings);
        return settings;
    }

    private static Range<Float> convertUnits(Range<Float> floatRange, String oldUnits, String newUnits) {
        SimpleUnit oldUnit = SimpleUnit.factory((String)oldUnits);
        SimpleUnit newUnit = SimpleUnit.factory((String)newUnits);
        if (oldUnit == null || newUnit == null) {
            return null;
        }
        try {
            return Ranges.newRange((Object)Float.valueOf((float)oldUnit.convertTo((double)((Float)floatRange.getMinimum()).floatValue(), newUnit)), (Object)Float.valueOf((float)oldUnit.convertTo((double)((Float)floatRange.getMaximum()).floatValue(), newUnit)));
        }
        catch (Exception e) {
            return null;
        }
    }

    private DatasetPathSettings getBestDatasetPathMatch(String urlPath) {
        DatasetPathSettings settings = this.datasetPaths.get(urlPath);
        if (settings != null) {
            return settings;
        }
        int longestPatternMatchLength = 0;
        DatasetPathSettings bestMatch = null;
        for (DatasetPathSettings dpSettings : this.datasetPaths.values()) {
            if (!dpSettings.pathSpecMatches(urlPath) || dpSettings.getPathSpec().length() <= longestPatternMatchLength) continue;
            longestPatternMatchLength = dpSettings.getPathSpec().length();
            bestMatch = dpSettings;
        }
        return bestMatch;
    }

    public static void main(String[] args) throws Exception {
        Range<Float> newRange = WmsDetailedConfig.convertUnits((Range<Float>)Ranges.newRange((Object)Float.valueOf(268.0f), (Object)Float.valueOf(305.0f)), "K", "Celsius");
        System.out.println(newRange);
        FileInputStream in = new FileInputStream("C:\\Documents and Settings\\Jon\\My Documents\\projects\\THREDDS\\svn\\tds\\src\\main\\webapp\\WEB-INF\\altContent\\startup\\wmsConfig.xml");
        WmsDetailedConfig wmsConfig = WmsDetailedConfig.fromInputStream(in);
        System.out.println(wmsConfig.defaultSettings);
        System.out.println();
        System.out.println("Dataset paths:");
        for (Map.Entry<String, DatasetPathSettings> entry : wmsConfig.datasetPaths.entrySet()) {
            System.out.println(entry.getKey());
            System.out.println(entry.getValue().getDefaultSettings());
            for (Map.Entry<String, LayerSettings> varEntry : entry.getValue().getSettingsPerVariable().entrySet()) {
                System.out.println("Variable " + varEntry.getKey() + ":");
                System.out.println("    " + varEntry.getValue());
            }
        }
        System.out.println();
        System.out.println("Standard names:");
        for (Map.Entry<String, Object> entry : wmsConfig.standardNames.entrySet()) {
            System.out.println(entry.getKey());
            System.out.println(((StandardNameSettings)entry.getValue()).getUnits());
            System.out.println(((StandardNameSettings)entry.getValue()).getSettings());
        }
    }
}

