/*
 * Decompiled with CFR 0.152.
 */
package thredds.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formatter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import thredds.server.exception.MethodNotImplementedException;
import thredds.server.exception.RequestTooLargeException;
import thredds.server.exception.ServiceNotAllowed;
import thredds.server.ncss.exception.NcssException;

@Configuration
@ControllerAdvice
public class TdsErrorHandling
implements HandlerExceptionResolver {
    private static Logger logger = LoggerFactory.getLogger(TdsErrorHandling.class);

    @ExceptionHandler(value={ServiceNotAllowed.class})
    public ResponseEntity<String> handle(ServiceNotAllowed ex) {
        logger.warn("TDS Error", (Throwable)ex);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)("Service Not Allowed: " + HtmlUtils.htmlEscape((String)ex.getMessage())), (MultiValueMap)responseHeaders, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={RequestTooLargeException.class})
    public ResponseEntity<String> handle(RequestTooLargeException ex) {
        logger.warn("TDS Error", (Throwable)ex);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)("Request Too Large: " + HtmlUtils.htmlEscape((String)ex.getMessage())), (MultiValueMap)responseHeaders, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={MethodNotImplementedException.class})
    public ResponseEntity<String> handle(MethodNotImplementedException ex) {
        logger.warn("TDS Error", (Throwable)ex);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)("Method not implemented: " + HtmlUtils.htmlEscape((String)ex.getMessage())), (MultiValueMap)responseHeaders, HttpStatus.NOT_IMPLEMENTED);
    }

    @ExceptionHandler(value={FileNotFoundException.class})
    public ResponseEntity<String> handle(FileNotFoundException ex) {
        logger.warn("TDS Error", (Throwable)ex);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)("FileNotFound: " + HtmlUtils.htmlEscape((String)ex.getMessage())), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={IOException.class})
    public ResponseEntity<String> handle(IOException ex) {
        String eName = ex.getClass().getName();
        if (eName.equals("org.apache.catalina.connector.ClientAbortException")) {
            logger.debug("ClientAbortException while sending file: ", (Throwable)ex);
            return null;
        }
        logger.warn("TDS Error", (Throwable)ex);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)("IOException sending File " + HtmlUtils.htmlEscape((String)ex.getMessage())), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<String> handle(IllegalArgumentException ex) {
        logger.warn("TDS Error", (Throwable)ex);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        String mess = ex.getMessage();
        if (mess != null && mess.startsWith("RequestTooLarge")) {
            return new ResponseEntity((Object)("Request Too Large: " + HtmlUtils.htmlEscape((String)mess)), (MultiValueMap)responseHeaders, HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity((Object)("IllegalArgumentException: " + HtmlUtils.htmlEscape((String)mess)), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NcssException.class})
    public ResponseEntity<String> handle(NcssException ex) {
        logger.warn("TDS Error", (Throwable)ex);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)("Invalid Request: " + HtmlUtils.htmlEscape((String)ex.getMessage())), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ServletRequestBindingException.class})
    public ResponseEntity<String> handle(ServletRequestBindingException ex) {
        logger.warn("TDS Error", (Throwable)ex);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)("Invalid Request: " + HtmlUtils.htmlEscape((String)ex.getMessage())), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={BindException.class})
    public ResponseEntity<String> handle(BindException ex) {
        BindingResult validationResult = ex.getBindingResult();
        List errors = validationResult.getAllErrors();
        Formatter f = new Formatter();
        f.format("Validation errors: ", new Object[0]);
        for (ObjectError err : errors) {
            f.format(" %s%n", err.getDefaultMessage());
        }
        logger.warn(f.toString(), (Throwable)ex);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)f.toString(), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<String> handle(Throwable ex) throws Throwable {
        if (AnnotationUtils.findAnnotation(ex.getClass(), ResponseStatus.class) != null) {
            throw ex;
        }
        logger.error("uncaught exception", ex);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        String msg = ex.getMessage();
        StringWriter sw = new StringWriter();
        PrintWriter p = new PrintWriter(sw);
        ex.printStackTrace(p);
        p.close();
        sw.close();
        msg = sw.toString();
        return new ResponseEntity((Object)("Throwable exception handled : " + HtmlUtils.htmlEscape((String)msg)), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        logger.error("uncaught exception 2", (Throwable)ex);
        return null;
    }
}

