/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.admin;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import thredds.server.config.TdsContext;
import thredds.servlet.ServletUtil;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.unidata.io.RandomAccessFile;

@Component
public class DebugCommands {
    @Autowired
    TdsContext tdsContext;
    private List<Category> dhList = new ArrayList<Category>();
    @Value(value="${tds.version}")
    private String webappVersion;
    @Value(value="${tds.version.builddate}")
    private String webappVersionBuildDate;

    public List<Category> getCategories() {
        return this.dhList;
    }

    public Category findCategory(String name) {
        for (Category dh : this.dhList) {
            if (!dh.name.equalsIgnoreCase(name)) continue;
            return dh;
        }
        return new Category(name);
    }

    public DebugCommands() {
        this.makeGeneralActions();
        this.makeDebugActions();
        this.makeCacheActions();
    }

    protected void makeCacheActions() {
        Category debugHandler = this.findCategory("Caches");
        Action act = new Action("showCaches", "Show All File Object Caches"){

            @Override
            public void doAction(Event e) {
                Formatter f = new Formatter(e.pw);
                FileCacheIF fc = RandomAccessFile.getGlobalFileCache();
                if (fc == null) {
                    f.format("%nRandomAccessFile : turned off%n", new Object[0]);
                } else {
                    f.format("%n%n", new Object[0]);
                    fc.showCache(f);
                }
                fc = NetcdfDataset.getNetcdfFileCache();
                if (fc == null) {
                    f.format("NetcdfDatasetFileCache : turned off%n", new Object[0]);
                } else {
                    f.format("%n%n", new Object[0]);
                    fc.showCache(f);
                }
                fc = NetcdfDatasets.getNetcdfFileCache();
                if (fc == null) {
                    f.format("NetcdfDatasetsFileCache : turned off%n", new Object[0]);
                } else {
                    f.format("%n%n", new Object[0]);
                    fc.showCache(f);
                }
                fc = GribCdmIndex.gribCollectionCache;
                if (fc == null) {
                    f.format("%nTimePartitionCache : turned off%n", new Object[0]);
                } else {
                    f.format("%n%n", new Object[0]);
                    fc.showCache(f);
                }
                e.pw.flush();
            }
        };
        debugHandler.addAction(act);
        act = new Action("clearCaches", "Clear All File Object Caches"){

            @Override
            public void doAction(Event e) {
                NetcdfDataset.getNetcdfFileCache().clearCache(false);
                NetcdfDatasets.getNetcdfFileCache().clearCache(false);
                RandomAccessFile.getGlobalFileCache().clearCache(false);
                FileCacheIF fc = GribCdmIndex.gribCollectionCache;
                if (fc != null) {
                    fc.clearCache(false);
                }
                e.pw.println("  ClearCache ok");
            }
        };
        debugHandler.addAction(act);
        act = new Action("disableRAFCache", "Disable RandomAccessFile Cache"){

            @Override
            public void doAction(Event e) {
                RandomAccessFile.getGlobalFileCache().disable();
                e.pw.println("  Disable RandomAccessFile Cache ok");
            }
        };
        debugHandler.addAction(act);
        act = new Action("forceRAFCache", "Force clear RandomAccessFile Cache"){

            @Override
            public void doAction(Event e) {
                RandomAccessFile.getGlobalFileCache().clearCache(true);
                e.pw.println("  RandomAccessFile force clearCache done");
            }
        };
        debugHandler.addAction(act);
        act = new Action("disableNetcdfCache", "Disable NetcdfDatasetFile Cache"){

            @Override
            public void doAction(Event e) {
                NetcdfDatasets.disableNetcdfFileCache();
                NetcdfDataset.disableNetcdfFileCache();
                e.pw.println("  Disable NetcdfFile Cache ok");
            }
        };
        debugHandler.addAction(act);
        act = new Action("forceNCCache", "Force clear NetcdfDatasetFile Cache"){

            @Override
            public void doAction(Event e) {
                NetcdfDatasets.getNetcdfFileCache().clearCache(true);
                NetcdfDataset.getNetcdfFileCache().clearCache(true);
                e.pw.println("  NetcdfFileCache force clearCache done");
            }
        };
        debugHandler.addAction(act);
        act = new Action("disableTimePartitionCache", "Disable TimePartition Cache"){

            @Override
            public void doAction(Event e) {
                GribCdmIndex.disableGribCollectionCache();
                e.pw.println("  Disable gribCollectionCache ok");
            }
        };
        debugHandler.addAction(act);
        act = new Action("forceGCCache", "Force clear TimePartition Cache"){

            @Override
            public void doAction(Event e) {
                FileCacheIF fc = GribCdmIndex.gribCollectionCache;
                if (fc != null) {
                    fc.clearCache(true);
                }
                e.pw.println("  gribCollectionCache force clearCache done");
            }
        };
        debugHandler.addAction(act);
    }

    protected void makeDebugActions() {
        Category debugHandler = this.findCategory("Debug");
        Action act = new Action("enableRafHandles", "Toggle tracking open RAF"){

            @Override
            public void doAction(Event e) {
                try {
                    RandomAccessFile.setDebugLeaks((!RandomAccessFile.getDebugLeaks() ? 1 : 0) != 0);
                    e.pw.println("  Tracking RAF=" + RandomAccessFile.getDebugLeaks());
                }
                catch (Exception ioe) {
                    e.pw.println(ioe.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
        act = new Action("showRafHandles", "Show open RAF"){

            @Override
            public void doAction(Event e) {
                try {
                    List names = RandomAccessFile.getOpenFiles();
                    e.pw.println("count=" + names.size());
                    for (String s : names) {
                        e.pw.println("  " + s);
                    }
                }
                catch (Exception ioe) {
                    e.pw.println(ioe.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
    }

    protected void makeGeneralActions() {
        Category debugHandler = this.findCategory("General");
        Action act = new Action("showVersion", "Show Build Version"){

            @Override
            public void doAction(Event e) {
                try {
                    e.pw.println("version= " + DebugCommands.this.webappVersion);
                    e.pw.println("build date= " + DebugCommands.this.webappVersionBuildDate);
                }
                catch (Exception ioe) {
                    e.pw.println(ioe.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
        act = new Action("showRuntime", "Show Runtime info"){

            @Override
            public void doAction(Event e) {
                Runtime runt = Runtime.getRuntime();
                double scale = 1.0E-6;
                e.pw.println(" freeMemory= " + scale * (double)runt.freeMemory() + " Mb");
                e.pw.println(" totalMemory= " + scale * (double)runt.totalMemory() + " Mb");
                e.pw.println(" maxMemory= " + scale * (double)runt.maxMemory() + " Mb");
                e.pw.println(" availableProcessors= " + runt.availableProcessors());
                e.pw.println();
                ServletUtil.showThreads(e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new Action("showRequest", "Show HTTP Request info"){

            @Override
            public void doAction(Event e) {
                e.pw.println(ServletUtil.showRequestDetail(e.req));
            }
        };
        debugHandler.addAction(act);
        act = new Action("showSystemProperties", "Show System Properties"){

            @Override
            public void doAction(Event e) {
                ServletUtil.showSystemProperties(e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new Action("showTdsContext", "Show TDS Context"){

            @Override
            public void doAction(Event e) {
                e.pw.println(DebugCommands.this.tdsContext.toString());
            }
        };
        debugHandler.addAction(act);
        act = new Action("showSession", "Show HTTP Session info"){

            @Override
            public void doAction(Event e) {
                ServletUtil.showSession(e.req, e.res, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new Action("showSecurity", "Show Security info"){

            @Override
            public void doAction(Event e) {
                e.pw.println(ServletUtil.showSecurity(e.req, "admin"));
            }
        };
        debugHandler.addAction(act);
    }

    public static class Event {
        public HttpServletRequest req;
        public HttpServletResponse res;
        public PrintStream pw;
        public ByteArrayOutputStream bos;
        public String target;

        public Event(HttpServletRequest req, HttpServletResponse res, PrintStream pw, ByteArrayOutputStream bos, String target) {
            this.req = req;
            this.res = res;
            this.pw = pw;
            this.bos = bos;
            this.target = target;
        }
    }

    public static abstract class Action {
        public String name;
        public String desc;

        public Action(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public abstract void doAction(Event var1);
    }

    public class Category {
        Map<String, Action> actions = new LinkedHashMap<String, Action>();
        String name;

        private Category(String name) {
            this.name = name;
            DebugCommands.this.dhList.add(this);
        }

        public void addAction(Action act) {
            this.actions.put(act.name, act);
        }
    }
}

