/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.util.Formatter;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class UsageLog {
    private static final AtomicLong logServerAccessId = new AtomicLong(0L);

    public static String setupRequestContext(HttpServletRequest req) {
        MDC.put((String)"ID", (String)Long.toString(logServerAccessId.incrementAndGet()));
        MDC.put((String)"startTime", (String)Long.toString(System.currentTimeMillis()));
        Object query = req.getQueryString();
        query = query != null ? "?" + (String)query : "";
        Formatter request = new Formatter();
        request.format("\"%s %s%s %s\"", req.getMethod(), req.getRequestURI(), query, req.getProtocol());
        MDC.put((String)"request", (String)request.toString());
        return "Remote host: " + req.getRemoteHost() + " - Request: " + request.toString();
    }

    public static String closingMessageForRequestContext(int resCode, long resSizeInBytes) {
        long duration = UsageLog.calculateElapsedTime();
        return "Request Completed - " + resCode + " - " + resSizeInBytes + " - " + duration;
    }

    public static String setupNonRequestContext() {
        MDC.put((String)"ID", (String)Long.toString(logServerAccessId.incrementAndGet()));
        MDC.put((String)"startTime", (String)Long.toString(System.currentTimeMillis()));
        return "Non-request thread opening.";
    }

    public static String closingMessageNonRequestContext() {
        long duration = UsageLog.calculateElapsedTime();
        return "Non-request thread closing - " + duration;
    }

    private static long calculateElapsedTime() {
        long endTime = System.currentTimeMillis();
        String startTimeS = MDC.get((String)"startTime");
        if (startTimeS == null) {
            return -1L;
        }
        long startTime = Long.parseLong(startTimeS);
        return endTime - startTime;
    }

    public void add2map(String key, String value) {
        MDC.put((String)key, (String)value);
    }
}

