/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.station;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.view.dsg.station.AbstractStationSubsetWriter;
import thredds.util.ContentType;
import thredds.util.TdsPathUtils;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.util.xml.Parse;
import ucar.unidata.util.Format;

public class StationSubsetWriterXML
extends AbstractStationSubsetWriter {
    private final XMLStreamWriter staxWriter;

    public StationSubsetWriterXML(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, OutputStream out) throws XMLStreamException, NcssException, IOException {
        super(fdPoint, ncssParams);
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.staxWriter = factory.createXMLStreamWriter(out, "UTF-8");
    }

    @Override
    public HttpHeaders getHttpHeaders(String datasetPath, boolean isStream) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (!isStream) {
            httpHeaders.set("Content-Location", datasetPath);
            String fileName = TdsPathUtils.getFileNameForResponse(datasetPath, ".xml");
            httpHeaders.set("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        }
        httpHeaders.set("Content-Type", ContentType.xml.getContentHeader());
        return httpHeaders;
    }

    @Override
    protected void writeHeader(StationPointFeature stationPointFeat) throws XMLStreamException {
        this.staxWriter.writeStartDocument("UTF-8", "1.0");
        this.staxWriter.writeCharacters("\n");
        this.staxWriter.writeStartElement("stationFeatureCollection");
    }

    @Override
    protected void writeStationPointFeature(StationPointFeature stationPointFeat) throws XMLStreamException, IOException {
        StationFeature station = stationPointFeat.getStation();
        this.staxWriter.writeCharacters("\n    ");
        this.staxWriter.writeStartElement("stationFeature");
        this.staxWriter.writeAttribute("date", CalendarDateFormatter.toDateTimeStringISO((CalendarDate)stationPointFeat.getObservationTimeAsCalendarDate()));
        this.staxWriter.writeCharacters("\n        ");
        this.staxWriter.writeStartElement("station");
        this.staxWriter.writeAttribute("name", station.getName());
        this.staxWriter.writeAttribute("latitude", Format.dfrac((double)station.getLatitude(), (int)3));
        this.staxWriter.writeAttribute("longitude", Format.dfrac((double)station.getLongitude(), (int)3));
        if (!Double.isNaN(station.getAltitude())) {
            this.staxWriter.writeAttribute("altitude", Format.dfrac((double)station.getAltitude(), (int)0));
        }
        if (station.getDescription() != null) {
            this.staxWriter.writeCharacters(station.getDescription());
        }
        this.staxWriter.writeEndElement();
        for (VariableSimpleIF wantedVar : this.wantedVariables) {
            this.staxWriter.writeCharacters("\n        ");
            this.staxWriter.writeStartElement("data");
            this.staxWriter.writeAttribute("name", wantedVar.getShortName());
            if (wantedVar.getUnitsString() != null) {
                this.staxWriter.writeAttribute("units", wantedVar.getUnitsString());
            }
            Array dataArray = stationPointFeat.getDataAll().getArray(wantedVar.getShortName());
            String ss = dataArray.toString();
            Class elemType = dataArray.getElementType();
            if (elemType == String.class || elemType == Character.TYPE || elemType == StructureData.class) {
                ss = Parse.cleanCharacterData((String)ss);
            }
            this.staxWriter.writeCharacters(ss.trim());
            this.staxWriter.writeEndElement();
        }
        this.staxWriter.writeCharacters("\n    ");
        this.staxWriter.writeEndElement();
    }

    @Override
    protected void writeFooter() throws XMLStreamException {
        this.staxWriter.writeCharacters("\n");
        this.staxWriter.writeEndElement();
        this.staxWriter.writeCharacters("\n");
        this.staxWriter.writeEndDocument();
        this.staxWriter.close();
    }
}

