/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.reify;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import thredds.server.config.TdsContext;
import thredds.util.ContentType;
import ucar.httpservices.HTTPUtil;

public abstract class LoadCommon {
    protected static final boolean DEBUG = true;
    protected static final String DEFAULTSERVLETNAME = "thredds";
    protected static int HTMLLEN = "<html>".length();
    protected static final String DEFAULTUPLOADFORM = "WEB-INF/upload.html";
    protected static final String DEFAULTDOWNLOADFORM = "WEB-INF/download.html";
    static Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    static Logger log = LoggerFactory.getLogger(LoadCommon.class);
    @Autowired
    protected TdsContext tdsContext = null;
    protected boolean initialized = false;
    protected boolean once = false;
    protected HttpServletRequest req = null;
    protected HttpServletResponse res = null;
    protected String server = null;
    protected String requestname = null;
    protected String threddsname = null;
    protected String uploaddir = null;
    protected String downloaddir = null;
    protected String downloaddirname = null;

    static File findSystemTempDir(String[] candidates) {
        for (String candidate : candidates) {
            File f = new File(candidate);
            if (f.exists() && f.canRead() && f.canWrite()) {
                return f;
            }
            if (!f.mkdirs()) continue;
            return f;
        }
        try {
            File tempfile = File.createTempFile("tmp", "tmp");
            File tempdir = tempfile.getParentFile();
            if (!tempdir.canWrite() || !tempdir.canRead()) {
                return null;
            }
            return tempdir;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String mapToString(Map<String, String> map, boolean encode, String ... order) {
        List<String> orderlist = order == null ? new ArrayList<String>(map.keySet()) : Arrays.asList(order);
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < orderlist.size(); ++i) {
            String key = orderlist.get(i);
            String value = map.get(key);
            if (value == null) continue;
            if (!first) {
                b.append("&");
            }
            b.append(key);
            b.append("=");
            b.append(encode ? LoadCommon.urlEncode(value) : value);
            first = false;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (orderlist.contains(entry.getKey())) continue;
            if (!first) {
                b.append("&");
            }
            b.append(entry.getKey());
            b.append("=");
            b.append(encode ? LoadCommon.urlEncode(entry.getValue()) : entry.getValue());
            first = false;
        }
        return b.toString();
    }

    public static Map<String, String> parseMap(String params, char sep, boolean decode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (params == null || params.length() == 0) {
            return map;
        }
        String[] pieces = params.split("[&]");
        for (int i = 0; i < pieces.length; ++i) {
            String piece = pieces[i].trim();
            String[] pair = piece.split("[=]");
            String key = pair[0].trim();
            if (pair.length >= 2) {
                String v = pair[1].trim();
                if (decode) {
                    v = LoadCommon.urlDecode(v);
                }
                map.put(key, v);
                continue;
            }
            if (pair.length == 1) {
                map.put(key, "");
                continue;
            }
            assert (false) : "split() failed";
        }
        return map;
    }

    public static List<String> parseList(String params, char sep, boolean decode) {
        ArrayList<String> list = new ArrayList<String>();
        if (params == null || params.length() == 0) {
            return list;
        }
        String regex = "[ ]*[" + sep + "][ ]*";
        String[] pieces = params.split(regex);
        for (int i = 0; i < pieces.length; ++i) {
            String piece = pieces[i];
            if (decode) {
                piece = LoadCommon.urlDecode(piece);
            }
            list.add(piece);
        }
        return list;
    }

    public static String urlEncode(String s) {
        block2: {
            try {
                s = URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e.getMessage());
            }
        }
        return s;
    }

    public static String urlDecode(String s) {
        block2: {
            try {
                s = URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e.getMessage());
            }
        }
        return s;
    }

    public static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        try {
            sw.close();
        }
        catch (IOException ioe) {
            return "close failure";
        }
        return sw.toString();
    }

    public LoadCommon() throws ServletException {
        if (!this.initialized) {
            this.init();
        }
    }

    public void init() throws ServletException {
        try {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            logServerStartup.info(this.getClass().getName() + " initialization");
            System.setProperty("file.encoding", "UTF-8");
            Field charset = Charset.class.getDeclaredField("defaultCharset");
            charset.setAccessible(true);
            charset.set(null, null);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void initOnce(HttpServletRequest req) throws SendError {
        File updir;
        if (this.once) {
            return;
        }
        this.once = true;
        log.info(this.getClass().getName() + " GET initialization");
        if (this.tdsContext == null) {
            throw new SendError(500, "Cannot find TDS Context");
        }
        StringBuilder buf = new StringBuilder();
        buf.append(req.getServerName());
        int port = req.getServerPort();
        if (port > 0) {
            buf.append(":");
            buf.append(port);
        }
        this.server = buf.toString();
        String tmp = HTTPUtil.canonicalpath((String)req.getContextPath());
        this.threddsname = HTTPUtil.nullify((String)HTTPUtil.relpath((String)tmp));
        tmp = HTTPUtil.canonicalpath((String)req.getServletPath());
        this.requestname = HTTPUtil.nullify((String)HTTPUtil.relpath((String)tmp));
        if (this.threddsname == null) {
            this.threddsname = DEFAULTSERVLETNAME;
        }
        if ((updir = this.tdsContext.getUploadDir()) == null) {
            log.warn("No tds.upload.dir specified");
            this.uploaddir = null;
        } else {
            this.uploaddir = HTTPUtil.canonicalpath((String)updir.getAbsolutePath());
        }
        File downdir = this.tdsContext.getDownloadDir();
        if (downdir == null) {
            log.warn("No tds.download.dir specified");
            this.downloaddir = null;
        } else {
            this.downloaddir = HTTPUtil.canonicalpath((String)downdir.getAbsolutePath());
        }
    }

    protected String inquire() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.downloaddir != null) {
            result.put("downloaddir", this.downloaddir);
        }
        if (this.uploaddir != null) {
            result.put("uploaddir", this.uploaddir);
        }
        String sresult = LoadCommon.mapToString(result, true, "download");
        return sresult;
    }

    protected void sendForm(String msg) {
        String reply = this.buildForm(msg);
        this.sendOK(reply);
    }

    protected void sendErrorForm(int code, String err) {
        String msg = String.format("Error: %d; %s", code, err);
        String reply = this.buildForm(msg);
        this.sendError(code, reply);
    }

    protected void sendOK(String msg) {
        this.sendReply(200, msg);
    }

    protected void sendError(int code, String msg) {
        this.sendError(code, msg, null);
    }

    protected void sendError(SendError se) {
        this.sendError(se.httpcode, se.getMessage(), se.getCause());
    }

    protected void sendError(int code, String msg, Throwable e) {
        System.err.printf("Error code=%d%n%s%n", code, msg);
        String trace = "";
        if (e != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter p = new PrintWriter(sw);
                e.printStackTrace(p);
                p.close();
                sw.close();
                trace = sw.toString();
            }
            catch (Exception ee) {
                trace = "";
            }
        }
        System.err.println(trace);
        System.err.flush();
        this.sendReply(code, msg);
    }

    protected void sendReply(int code, String msg) {
        try {
            this.res.setStatus(code);
            String prefix = msg.trim();
            boolean usetext = prefix.length() < HTMLLEN ? true : !"<html>".equalsIgnoreCase(prefix = prefix.substring(0, HTMLLEN));
            this.res.setContentType(usetext ? ContentType.text.getContentHeader() : ContentType.html.getContentHeader());
            try {
                PrintWriter pw = this.res.getWriter();
                pw.print(msg);
                pw.close();
                pw.flush();
                this.res.flushBuffer();
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage());
            }
        }
        catch (Exception e) {
            this.res.setStatus(500);
        }
    }

    protected static void reportRequest(HttpServletRequest req) {
        System.err.println("========= Controller ==========\n");
        try {
            System.err.println("Headers:\n");
            for (String key : LoadCommon.enum2list(req.getHeaderNames())) {
                System.err.printf("\t%s = ", key);
                Enumeration strings = req.getHeaders(key);
                for (String value : LoadCommon.enum2list(strings)) {
                    System.err.printf(" %s", value);
                }
                System.err.println();
            }
            Collection parts = req.getParts();
            System.err.printf("Parts: |parts|=%d%n", parts.size());
            for (Part part : parts) {
                String field = part.getName();
                LoadCommon.reportPart(part);
            }
        }
        catch (IOException | ServletException throwable) {
            // empty catch block
        }
        System.err.println("=========\n");
        System.err.flush();
    }

    static void reportPart(Part part) {
        String field = part.getName();
        String type = part.getContentType();
        long size = part.getSize();
        System.err.printf("Part: %s type=%s size=%d: %n\tHeaders:%n", field, type, size);
        for (String key : LoadCommon.iter2list(part.getHeaderNames().iterator())) {
            System.err.printf("\t\t%s = ", key);
            for (String value : LoadCommon.iter2list(part.getHeaders(key).iterator())) {
                System.err.printf(" %s", key);
            }
            System.err.println();
        }
        String fname = HTTPUtil.nullify((String)part.getSubmittedFileName());
        if (fname != null) {
            System.err.printf("\tfilename=|%s|%n", fname);
        }
        if (size < 50L) {
            try {
                InputStream stream = part.getInputStream();
                String value = HTTPUtil.nullify((String)HTTPUtil.readtextfile((InputStream)stream));
                System.err.printf("\tvalue=|%s|%n", value);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    static List<String> iter2list(Iterator<String> e) {
        ArrayList<String> names = new ArrayList<String>();
        while (e.hasNext()) {
            String name = e.next();
            names.add(name);
        }
        return names;
    }

    static List<String> enum2list(Enumeration<String> e) {
        ArrayList<String> names = new ArrayList<String>();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            names.add(name);
        }
        return names;
    }

    protected abstract String buildForm(String var1);

    static String loadForm(File form) throws IOException {
        if (form == null) {
            throw new SendError(412, "No form path specified");
        }
        if (!form.exists()) {
            throw new SendError(412, "HTML form does not exist: " + form.getName());
        }
        if (!form.canRead()) {
            throw new SendError(500, "HTML form not readable: " + form.getName());
        }
        try {
            FileInputStream fis = new FileInputStream(form);
            String content = HTTPUtil.readtextfile((InputStream)fis);
            fis.close();
            return content;
        }
        catch (IOException e) {
            logServerStartup.warn("Cannot read HTML form file: " + form.getName());
            throw e;
        }
    }

    public static class SendError
    extends RuntimeException {
        public int httpcode = 0;

        public SendError(int httpcode) {
            this(httpcode, (String)null);
        }

        public SendError(int httpcode, Exception t) {
            this(httpcode, t.getMessage(), t);
        }

        public SendError(int httpcode, String msg) {
            this(httpcode, msg, null);
        }

        public SendError(int httpcode, String msg, Exception t) {
            super(msg == null ? "" : msg, t);
            if (httpcode == 0) {
                httpcode = 400;
            }
            this.httpcode = httpcode;
        }
    }

    static enum FileFormat {
        NETCDF3("nc3"),
        NETCDF4("nc4");

        private String extension;

        public final String getName() {
            return this.toString().toLowerCase();
        }

        public final String getExtension() {
            return this.extension;
        }

        private FileFormat(String ext) {
            this.extension = ext;
        }

        public static FileFormat getformat(String fmt) {
            if (fmt == null) {
                return null;
            }
            for (FileFormat rf : FileFormat.values()) {
                if (!fmt.equalsIgnoreCase(rf.toString())) continue;
                return rf;
            }
            return null;
        }
    }

    static enum Inquiry {
        DOWNLOADDIR("downloaddir"),
        UPLOADDIR("uploaddir"),
        USERNAME("username");

        private String key;

        private Inquiry(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static Inquiry parse(String key) {
            if (key == null) {
                return null;
            }
            for (Inquiry x : Inquiry.values()) {
                if (!key.equalsIgnoreCase(x.toString())) continue;
                return x;
            }
            return null;
        }
    }

    static enum Command {
        NONE,
        UPLOAD,
        DOWNLOAD,
        INQUIRE;


        public static Command parse(String cmd) {
            if (cmd == null) {
                return null;
            }
            for (Command x : Command.values()) {
                if (!cmd.equalsIgnoreCase(x.toString())) continue;
                return x;
            }
            return null;
        }
    }
}

