/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import thredds.core.TdsRequestedDataset;
import thredds.server.wms.ThreddsWmsCatalogue;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import uk.ac.rdg.resc.edal.graphics.exceptions.EdalLayerNotFoundException;
import uk.ac.rdg.resc.edal.wms.RequestParams;
import uk.ac.rdg.resc.edal.wms.WmsCatalogue;
import uk.ac.rdg.resc.edal.wms.WmsServlet;

@Controller
@RequestMapping(value={"/wms"})
public class ThreddsWmsServlet
extends WmsServlet {
    private static final Map<String, WmsCatalogue> catalogueCache = new HashMap<String, WmsCatalogue>();

    @RequestMapping(value={"**"}, method={RequestMethod.GET})
    protected void dispatchWmsRequest(String request, RequestParams params, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WmsCatalogue catalogue) throws Exception {
        String removePrefix = null;
        TdsRequestedDataset tdsDataset = new TdsRequestedDataset(httpServletRequest, removePrefix);
        if (catalogueCache.containsKey(tdsDataset.getPath())) {
            catalogue = catalogueCache.get(tdsDataset.getPath());
        } else {
            NetcdfFile ncf = TdsRequestedDataset.getNetcdfFile(httpServletRequest, httpServletResponse, tdsDataset.getPath());
            NetcdfDataset ncd = TdsRequestedDataset.useNetcdfJavaBuilders() ? NetcdfDatasets.enhance((NetcdfFile)ncf, (Set)NetcdfDataset.getDefaultEnhanceMode(), null) : NetcdfDataset.wrap((NetcdfFile)ncf, (Set)NetcdfDataset.getDefaultEnhanceMode());
            String netcdfFilePath = ncf.getLocation();
            if (netcdfFilePath == null) {
                throw new EdalLayerNotFoundException("The requested dataset is not available on this server");
            }
            catalogue = new ThreddsWmsCatalogue(ncd, tdsDataset.getPath());
            catalogueCache.put(tdsDataset.getPath(), catalogue);
        }
        super.dispatchWmsRequest(request, params, httpServletRequest, httpServletResponse, catalogue);
    }
}

