/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Service;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import thredds.core.AllowedServices;
import thredds.core.DataRootManager;
import thredds.featurecollection.FeatureCollectionCache;
import thredds.featurecollection.InvDatasetFeatureCollection;
import thredds.server.catalog.CatalogReader;
import thredds.server.catalog.CatalogScan;
import thredds.server.catalog.ConfigCatalog;
import thredds.server.catalog.ConfigCatalogCache;
import thredds.server.catalog.DatasetScan;
import thredds.server.config.TdsContext;

@Component(value="CatalogManager")
public class CatalogManager {
    private static Logger log = LoggerFactory.getLogger(CatalogManager.class);
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private ConfigCatalogCache ccc;
    @Autowired
    private FeatureCollectionCache featureCollectionCache;
    @Autowired
    private DataRootManager dataRootManager;
    @Autowired
    private AllowedServices globalServices;

    public Catalog getCatalog(String path, URI baseURI) throws IOException {
        Object dyno;
        if (path == null) {
            return null;
        }
        String workPath = path;
        if (workPath.startsWith("/")) {
            workPath = workPath.substring(1);
        }
        if ((dyno = this.makeDynamicCatalog(workPath, baseURI)) != null) {
            CatalogBuilder catBuilder;
            if (dyno instanceof CatalogBuilder) {
                catBuilder = (CatalogBuilder)dyno;
            } else {
                ConfigCatalog configCatalog = (ConfigCatalog)dyno;
                catBuilder = configCatalog.makeCatalogBuilder();
            }
            this.addGlobalServices(catBuilder);
            return catBuilder.makeCatalog();
        }
        ConfigCatalog configCatalog = this.ccc.get(workPath);
        if (configCatalog == null) {
            return null;
        }
        CatalogBuilder catBuilder = configCatalog.makeCatalogBuilder();
        this.addGlobalServices(catBuilder);
        return catBuilder.makeCatalog();
    }

    private Object makeDynamicCatalog(String path, URI baseURI) throws IOException {
        boolean isLatest = path.endsWith("/latest.xml");
        int pos = path.lastIndexOf("/");
        String workPath = pos >= 0 ? path.substring(0, pos) : path;
        String filename = pos > 0 ? path.substring(pos + 1) : path;
        DataRootManager.DataRootMatch match = this.dataRootManager.findDataRootMatch(workPath);
        if (match == null) {
            return null;
        }
        if (match.dataRoot.getFeatureCollection() != null) {
            InvDatasetFeatureCollection fc = this.featureCollectionCache.get(match.dataRoot.getFeatureCollection());
            if (isLatest) {
                return fc.makeLatest(match.remaining, path, baseURI);
            }
            return fc.makeCatalog(match.remaining, path, baseURI);
        }
        DatasetScan dscan = match.dataRoot.getDatasetScan();
        if (dscan != null) {
            CatalogBuilder cat;
            if (log.isDebugEnabled()) {
                log.debug("makeDynamicCatalog(): Calling DatasetScan.makeCatalogForDirectory( " + baseURI + ", " + path + ").");
            }
            if (null == (cat = isLatest ? dscan.makeCatalogForLatest(workPath, baseURI) : dscan.makeCatalogForDirectory(workPath, baseURI))) {
                log.error("makeDynamicCatalog(): DatasetScan.makeCatalogForDirectory failed = " + workPath);
            }
            return cat;
        }
        CatalogScan catScan = match.dataRoot.getCatalogScan();
        if (catScan != null) {
            CatalogBuilder cat;
            if (!filename.equalsIgnoreCase("catalogScan.xml")) {
                return catScan.getCatalog(this.tdsContext.getThreddsDirectory(), match.remaining, filename, (CatalogReader)this.ccc);
            }
            if (log.isDebugEnabled()) {
                log.debug("makeDynamicCatalog(): Calling CatalogScan.makeCatalogForDirectory( " + baseURI + ", " + path + ").");
            }
            if (null == (cat = catScan.makeCatalogFromDirectory(this.tdsContext.getThreddsDirectory(), match.remaining, baseURI))) {
                log.error("makeDynamicCatalog(): CatalogScan.makeCatalogForDirectory failed = " + workPath);
            }
            return cat;
        }
        log.warn("makeDynamicCatalog() failed for =" + workPath + " request path= " + path);
        return null;
    }

    private void addGlobalServices(CatalogBuilder cat) {
        HashSet<String> allServiceNames = new HashSet<String>();
        this.findServices(cat.getDatasets(), allServiceNames);
        if (!allServiceNames.isEmpty()) {
            ArrayList<Service> servicesMissing = new ArrayList<Service>();
            for (String name : allServiceNames) {
                Service s;
                if (cat.hasServiceInDataset(name) || (s = this.globalServices.findGlobalService(name)) == null) continue;
                servicesMissing.add(s);
            }
            servicesMissing.forEach(arg_0 -> ((CatalogBuilder)cat).addService(arg_0));
        }
        for (DatasetBuilder node : cat.getDatasets()) {
            Service s;
            String sname = (String)node.getFldOrInherited("ServiceName");
            String urlPath = (String)node.get("UrlPath");
            String ftypeS = (String)node.getFldOrInherited("FeatureType");
            if (sname != null || urlPath == null || ftypeS == null || (s = this.globalServices.getStandardServices(ftypeS)) == null) continue;
            node.put("ServiceName", (Object)s.getName());
            cat.addService(s);
        }
    }

    private void findServices(Iterable<DatasetBuilder> datasets, Set<String> serviceNames) {
        for (DatasetBuilder ds : datasets) {
            String sname = (String)ds.getFldOrInherited("ServiceName");
            if (sname != null) {
                serviceNames.add(sname);
            }
            this.findServices(ds.getDatasets(), serviceNames);
        }
    }
}

