/*
 * Decompiled with CFR 0.152.
 */
package thredds.featurecollection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import thredds.featurecollection.CollectionUpdater;
import thredds.featurecollection.InvDatasetFeatureCollection;
import thredds.server.catalog.FeatureCollectionRef;

@Component
public class FeatureCollectionCache
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(FeatureCollectionCache.class);
    @Autowired
    @Qualifier(value="fcTriggerEventBus")
    private EventBus eventBus;
    @Autowired
    CollectionUpdater collectionUpdater;
    private Cache<String, InvDatasetFeatureCollection> cache;

    public FeatureCollectionCache() {
    }

    public FeatureCollectionCache(int maxSize) {
        RemovalListener<String, InvDatasetFeatureCollection> removalListener = new RemovalListener<String, InvDatasetFeatureCollection>(){

            public void onRemoval(RemovalNotification<String, InvDatasetFeatureCollection> removal) {
                InvDatasetFeatureCollection fc = (InvDatasetFeatureCollection)removal.getValue();
                if (fc != null) {
                    fc.close();
                }
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).recordStats().removalListener((RemovalListener)removalListener).build();
    }

    public void afterPropertiesSet() {
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).recordStats().build();
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public InvDatasetFeatureCollection get(final FeatureCollectionRef fcr) throws IOException {
        try {
            return (InvDatasetFeatureCollection)this.cache.get((Object)fcr.getCollectionName(), (Callable)new Callable<InvDatasetFeatureCollection>(){

                @Override
                public InvDatasetFeatureCollection call() throws IOException {
                    return FeatureCollectionCache.this.makeFeatureCollection(fcr);
                }
            });
        }
        catch (ExecutionException e) {
            Throwable c = e.getCause();
            if (c instanceof IOException) {
                throw (IOException)c;
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private InvDatasetFeatureCollection makeFeatureCollection(FeatureCollectionRef fcr) throws IOException {
        try {
            InvDatasetFeatureCollection result = InvDatasetFeatureCollection.factory(fcr, fcr.getConfig());
            this.eventBus.register((Object)result);
            this.collectionUpdater.scheduleTasks(fcr.getConfig(), null);
            return result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException(t);
        }
    }
}

