/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.ServiceType;
import thredds.server.catalog.CatalogScan;
import thredds.server.catalog.ConfigCatalogCache;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.catalogservice.CatalogItemContext;
import thredds.server.catalogservice.DatasetContext;
import thredds.server.catalogservice.JsonLD;
import thredds.server.catalogservice.RemoteCatalogRequest;
import thredds.server.config.HtmlConfigBean;
import thredds.server.config.TdsContext;
import thredds.server.config.TdsServerInfoBean;
import thredds.server.viewer.ViewerService;
import ucar.unidata.util.StringUtil2;

@Component
public class CatalogViewContextParser {
    @Autowired
    private ViewerService viewerService;
    @Autowired
    private HtmlConfigBean htmlConfig;
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private TdsServerInfoBean serverInfo;
    @Autowired
    private ConfigCatalogCache ccc;

    public Map<String, Object> getCatalogViewContext(Catalog cat, HttpServletRequest req, boolean isLocalCatalog) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        String baseUrl = CatalogViewContextParser.getBaseCatUrl(cat.getBaseURI().toString(), req);
        this.addBaseContext(model, baseUrl + "/");
        String catName = cat.getBaseURI().toString();
        String serviceStr = ServiceType.Catalog.name().toLowerCase();
        if (catName.contains(serviceStr)) {
            catName = catName.substring(catName.indexOf(serviceStr) + serviceStr.length() + 1);
        }
        boolean isRoot = this.ccc.isRoot(catName);
        model.put("rootCatalog", isRoot);
        ArrayList<CatalogItemContext> catalogItems = new ArrayList<CatalogItemContext>();
        this.addCatalogItems((DatasetNode)cat, catalogItems, isLocalCatalog, 0);
        model.put("items", catalogItems);
        return model;
    }

    public Map<String, Object> getDatasetViewContext(Dataset ds, HttpServletRequest req, boolean isLocalCatalog) {
        String jsonLD;
        HashMap<String, Object> model = new HashMap<String, Object>();
        String baseUrl = CatalogViewContextParser.getBaseCatUrl(ds.getCatalogUrl(), req);
        this.addBaseContext(model, baseUrl + "/");
        DatasetContext context = new DatasetContext(ds, isLocalCatalog, this.tdsContext, req);
        this.populateDatasetContext(ds, context, req, isLocalCatalog);
        model.put("dataset", context);
        if (this.htmlConfig.getGenerateDatasetJsonLD().booleanValue() && !(jsonLD = JsonLD.makeDatasetJsonLD(ds, context, this.tdsContext)).isEmpty()) {
            model.put("jsonLD", jsonLD);
        }
        return model;
    }

    private static String getBaseCatUrl(String catUrl, HttpServletRequest req) {
        String serviceStr;
        String baseUrl = CatalogViewContextParser.getAbsoluteCatUrl(catUrl, req);
        if (baseUrl.contains(serviceStr = ServiceType.Catalog.name().toLowerCase())) {
            baseUrl = baseUrl.substring(0, baseUrl.indexOf(serviceStr) + serviceStr.length());
        }
        return baseUrl;
    }

    static String getAbsoluteCatUrl(String catUrl, HttpServletRequest req) {
        String reqUri;
        if (((String)catUrl).indexOf(35) > 0) {
            catUrl = ((String)catUrl).substring(0, ((String)catUrl).lastIndexOf(35));
        }
        if (((String)(catUrl = ((String)catUrl).replace("xml", "html"))).startsWith("/") && (reqUri = req.getRequestURL().toString()).contains(req.getContextPath())) {
            String baseUriString = reqUri.split(req.getContextPath())[0];
            catUrl = baseUriString + (String)catUrl;
        }
        return catUrl;
    }

    private void addBaseContext(Map<String, Object> model, String baseUrl) {
        String googleTrackingCode = this.htmlConfig.getGoogleTrackingCode();
        if (googleTrackingCode.isEmpty()) {
            googleTrackingCode = null;
        }
        model.put("googleTracking", googleTrackingCode);
        model.put("serverName", this.serverInfo.getName());
        model.put("logoUrl", this.serverInfo.getLogoUrl());
        model.put("logoAlt", this.serverInfo.getLogoAltText());
        model.put("installName", this.htmlConfig.getInstallName());
        model.put("installUrl", baseUrl + this.htmlConfig.getInstallUrl());
        model.put("webappName", this.htmlConfig.getWebappName());
        model.put("webappUrl", this.htmlConfig.getWebappUrl());
        model.put("webappVersion", this.htmlConfig.getWebappVersion());
        model.put("webappBuildTimestamp", this.htmlConfig.getWebappVersionBuildDate());
        model.put("webappDocsUrl", this.htmlConfig.getWebappDocsUrl());
        model.put("contextPath", this.htmlConfig.getWebappContextPath());
        model.put("hostInst", this.htmlConfig.getHostInstName());
        model.put("hostInstUrl", this.htmlConfig.getHostInstUrl());
        model.put("standardCSS", this.htmlConfig.getPageCssUrl());
        model.put("catalogCSS", this.htmlConfig.getCatalogCssUrl());
        model.put("datasetCSS", this.htmlConfig.getDatasetCssUrl());
    }

    protected void addCatalogItems(DatasetNode cat, List<CatalogItemContext> catalogItems, boolean isLocalCatalog, int level) {
        for (Dataset ds : cat.getDatasets()) {
            this.populateItemContext(ds, catalogItems, isLocalCatalog, level);
        }
    }

    protected void populateItemContext(Dataset ds, List<CatalogItemContext> catalogItems, boolean isLocalCatalog, int level) {
        CatalogItemContext context = new CatalogItemContext(ds, level);
        context.setHref(this.getCatalogItemHref(ds, isLocalCatalog));
        context.setIconSrc(this.getFolderIconSrc(ds));
        catalogItems.add(context);
        if (!(ds instanceof CatalogRef)) {
            this.addCatalogItems((DatasetNode)ds, catalogItems, isLocalCatalog, level + 1);
        }
    }

    protected void populateDatasetContext(Dataset ds, DatasetContext context, HttpServletRequest req, boolean isLocalCatalog) {
        if (ds instanceof CatalogRef) {
            CatalogRef catref = (CatalogRef)ds;
            context.addContextItem("href", this.getCatalogRefHref(catref, isLocalCatalog));
        }
        if (isLocalCatalog) {
            context.setViewers(ds, this.viewerService.getViewerLinks(ds, req));
        }
    }

    private String getCatalogItemHref(Dataset ds, boolean isLocalCatalog) {
        if (ds instanceof CatalogRef) {
            CatalogRef catref = (CatalogRef)ds;
            Object href = catref.getXlinkHref();
            if (!isLocalCatalog) {
                URI hrefUri = ds.getParentCatalog().getBaseURI().resolve((String)href);
                href = hrefUri.toString();
            }
            try {
                URI uri = new URI((String)href);
                if (uri.isAbsolute()) {
                    boolean defaultUseRemoteCatalogService = this.htmlConfig.getUseRemoteCatalogService();
                    Boolean dsUseRemoteCatalogService = ((CatalogRef)ds).useRemoteCatalogService();
                    boolean useRemoteCatalogService = defaultUseRemoteCatalogService;
                    if (dsUseRemoteCatalogService == null) {
                        dsUseRemoteCatalogService = defaultUseRemoteCatalogService;
                    }
                    if (defaultUseRemoteCatalogService != dsUseRemoteCatalogService) {
                        useRemoteCatalogService = dsUseRemoteCatalogService;
                    }
                    if (useRemoteCatalogService) {
                        href = this.tdsContext.getContextPath() + "/remoteCatalogService?catalog=" + (String)href;
                    } else {
                        int pos = ((String)href).lastIndexOf(46);
                        href = ((String)href).substring(0, pos) + ".html";
                    }
                } else {
                    int pos = ((String)href).lastIndexOf(46);
                    href = ((String)href).substring(0, pos) + ".html";
                }
            }
            catch (Exception uri) {
                // empty catch block
            }
            return href;
        }
        if (ds.getAccess().size() == 1 && ServiceType.Resolver == ((Access)ds.getAccess().get(0)).getService().getType()) {
            Access access = (Access)ds.getAccess().get(0);
            Object accessUrlName = access.getUnresolvedUrlName();
            int pos = ((String)accessUrlName).lastIndexOf(".xml");
            if (((String)accessUrlName).equalsIgnoreCase("latest.xml") && !isLocalCatalog) {
                String catBaseUriPath = "";
                String catBaseUri = ds.getParentCatalog().getBaseURI().toString();
                pos = catBaseUri.lastIndexOf("catalog.xml");
                if (pos != -1) {
                    catBaseUriPath = catBaseUri.substring(0, pos);
                }
                accessUrlName = this.tdsContext.getContextPath() + "/remoteCatalogService?catalog=" + catBaseUriPath + (String)accessUrlName;
            } else if (pos != -1) {
                accessUrlName = ((String)accessUrlName).substring(0, pos) + ".html";
            }
            return accessUrlName;
        }
        if (ds.findProperty("NotAThreddsDataset") != null) {
            return this.makeFileServerUrl(ds);
        }
        if (ds.getID() != null) {
            Object catHtml;
            Catalog cat = ds.getParentCatalog();
            if (!isLocalCatalog) {
                catHtml = this.tdsContext.getContextPath() + "/remoteCatalogService?command=" + RemoteCatalogRequest.Command.SUBSET + "&catalog=" + cat.getUriString() + "&";
            } else {
                int pos;
                URI catURI = cat.getBaseURI();
                catHtml = catURI.getPath();
                if (catHtml == null) {
                    catHtml = cat.getUriString();
                }
                if ((pos = ((String)catHtml).lastIndexOf("/")) != -1) {
                    catHtml = ((String)catHtml).substring(pos + 1);
                }
                catHtml = (pos = ((String)catHtml).lastIndexOf(46)) < 0 ? (String)catHtml + "catalog.html?" : ((String)catHtml).substring(0, pos) + ".html?";
            }
            return (String)catHtml + "dataset=" + StringUtil2.replace((String)ds.getID(), (char)'+', (String)"%2B");
        }
        return null;
    }

    private String getCatalogRefHref(CatalogRef catref, boolean isLocalCatalog) {
        String href = catref.getXlinkHref();
        if (!isLocalCatalog) {
            href = CatalogViewContextParser.makeHrefResolve((Dataset)catref, href);
        }
        return href;
    }

    protected static String makeHrefResolve(Dataset ds, String href) {
        Catalog cat = ds.getParentCatalog();
        if (cat != null) {
            try {
                URI uri = cat.resolveUri(href);
                href = uri.toString();
            }
            catch (URISyntaxException e) {
                return "CatalogViewContextParser: error parsing URL= " + href;
            }
        }
        return href;
    }

    private String getFolderIconSrc(Dataset ds) {
        String iconSrc = null;
        if (ds instanceof CatalogRef) {
            iconSrc = ds instanceof CatalogScan || ds.hasProperty("CatalogScan") ? "cat_folder.png" : (ds instanceof DatasetScan || ds.hasProperty("DatasetScan") ? "scan_folder.png" : (ds instanceof FeatureCollectionRef ? "fc_folder.png" : "folder.png"));
        } else if (ds.hasNestedDatasets()) {
            iconSrc = "folder.png";
        }
        if (iconSrc != null) {
            iconSrc = this.htmlConfig.prepareUrlStringForHtml(iconSrc);
        }
        return iconSrc;
    }

    private String makeFileServerUrl(Dataset ds) {
        Access acc = ds.getAccess(ServiceType.HTTPServer);
        assert (acc != null);
        return acc.getStandardUrlName();
    }
}

