/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.validation;

import com.google.common.base.Strings;
import java.text.ParseException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.validation.TimeParamsConstraint;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

public class TimeParamsValidator
implements ConstraintValidator<TimeParamsConstraint, NcssParamsBean> {
    public void initialize(TimeParamsConstraint constraintAnnotation) {
    }

    public boolean isValid(NcssParamsBean params, ConstraintValidatorContext constraintValidatorContext) {
        CalendarDate end;
        CalendarDate start;
        constraintValidatorContext.disableDefaultConstraintViolation();
        String time = params.getTime();
        String time_window = params.getTime_window();
        if (time != null) {
            if ("all".equals(time)) {
                return true;
            }
            CalendarDate cd = TimeParamsValidator.validateISOString(time, "{thredds.server.ncSubset.validation.param.time}", constraintValidatorContext);
            if (cd != null) {
                params.setDate(cd);
            }
            if (time_window != null) {
                try {
                    params.setTimeWindow(new TimeDuration(time_window));
                }
                catch (ParseException pe) {
                    constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.param.time_window}").addConstraintViolation();
                    return false;
                }
            }
            return cd != null;
        }
        String time_start = params.getTime_start();
        String time_end = params.getTime_end();
        String time_duration = params.getTime_duration();
        if (TimeParamsValidator.nullOrEmpty(time_start) && TimeParamsValidator.nullOrEmpty(time_end) && TimeParamsValidator.nullOrEmpty(time_duration)) {
            return true;
        }
        if (!this.hasValidDateRange(time_start, time_end, time_duration)) {
            constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.time.2of3}").addConstraintViolation();
            return false;
        }
        boolean isValid = true;
        if (!TimeParamsValidator.nullOrEmpty(time_start)) {
            boolean bl = isValid = null != TimeParamsValidator.validateISOString(time_start, "{thredds.server.ncSubset.validation.param.time_start}", constraintValidatorContext);
        }
        if (!TimeParamsValidator.nullOrEmpty(time_end)) {
            isValid &= null != TimeParamsValidator.validateISOString(time_end, "{thredds.server.ncSubset.validation.param.time_end}", constraintValidatorContext);
        }
        if (!TimeParamsValidator.nullOrEmpty(time_duration)) {
            try {
                new TimeDuration(time_duration);
            }
            catch (ParseException pe) {
                isValid = false;
                constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.param.time_duration}").addConstraintViolation();
            }
        }
        if (isValid && !TimeParamsValidator.nullOrEmpty(time_start) && !TimeParamsValidator.nullOrEmpty(time_end) && (start = TimeParamsValidator.isoString2Date(time_start)).isAfter(end = TimeParamsValidator.isoString2Date(time_end))) {
            isValid = false;
            constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.time.start_gt_end}").addConstraintViolation();
        }
        if (isValid) {
            try {
                Calendar cal = Calendar.getDefault();
                DateRange dr = new DateRange(new DateType(time_start, null, null, cal), new DateType(time_end, null, null, cal), new TimeDuration(time_duration), null);
                CalendarDateRange cdr = CalendarDateRange.of((CalendarDate)dr.getStart().getCalendarDate(), (CalendarDate)dr.getEnd().getCalendarDate());
                params.setDateRange(cdr);
            }
            catch (ParseException pe) {
                isValid = false;
                constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.timeparams}").addConstraintViolation();
            }
        }
        return isValid;
    }

    private boolean hasValidDateRange(String time_start, String time_end, String time_duration) {
        if (TimeParamsValidator.nullOrEmpty(time_start) && TimeParamsValidator.nullOrEmpty(time_end) && TimeParamsValidator.nullOrEmpty(time_duration)) {
            return false;
        }
        if (!TimeParamsValidator.nullOrEmpty(time_start) && !TimeParamsValidator.nullOrEmpty(time_end)) {
            return true;
        }
        return (!TimeParamsValidator.nullOrEmpty(time_start) || !TimeParamsValidator.nullOrEmpty(time_end)) && !TimeParamsValidator.nullOrEmpty(time_duration);
    }

    public static CalendarDate validateISOString(String isoString, String msg, ConstraintValidatorContext constraintValidatorContext) {
        try {
            return TimeParamsValidator.isoString2Date(isoString);
        }
        catch (IllegalArgumentException iea) {
            constraintValidatorContext.buildConstraintViolationWithTemplate(msg).addConstraintViolation();
            return null;
        }
    }

    private static CalendarDate isoString2Date(String isoString) {
        if ("present".equalsIgnoreCase(isoString)) {
            return CalendarDate.present();
        }
        return CalendarDateFormatter.isoStringToCalendarDate((Calendar)Calendar.getDefault(), (String)isoString);
    }

    private static boolean nullOrEmpty(String str) {
        return Strings.isNullOrEmpty((String)str);
    }
}

