/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.any_point;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.view.dsg.DsgSubsetWriter;
import thredds.server.ncss.view.dsg.HttpHeaderWriter;
import thredds.server.ncss.view.dsg.any_point.AbstractMixedFeatureTypeSubsetWriter;
import thredds.server.ncss.view.dsg.point.PointSubsetWriterXML;
import thredds.server.ncss.view.dsg.station.StationProfileSubsetWriterXML;
import thredds.server.ncss.view.dsg.station.StationSubsetWriterXML;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft2.coverage.SubsetParams;

public class MixedFeatureTypeSubsetWriterXML
extends AbstractMixedFeatureTypeSubsetWriter {
    private final XMLStreamWriter staxWriter;

    public MixedFeatureTypeSubsetWriterXML(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, OutputStream out) throws NcssException, XMLStreamException, IOException {
        super(fdPoint, ncssParams, out);
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.staxWriter = factory.createXMLStreamWriter(out, "UTF-8");
        this.initWriters();
    }

    @Override
    DsgSubsetWriter newInstance(FeatureType featureType, int collectionIndex) throws XMLStreamException, NcssException, IOException {
        switch (featureType) {
            case POINT: {
                return new PointSubsetWriterXML(this.fdPoint, this.ncssParams, this.out, collectionIndex, this.staxWriter);
            }
            case STATION: {
                return new StationSubsetWriterXML(this.fdPoint, this.ncssParams, this.out, collectionIndex, this.staxWriter);
            }
            case STATION_PROFILE: {
                return new StationProfileSubsetWriterXML(this.fdPoint, this.ncssParams, this.out, collectionIndex, this.staxWriter);
            }
        }
        throw new UnsupportedOperationException(String.format("%s feature type is not yet supported.", featureType));
    }

    @Override
    public HttpHeaders getHttpHeaders(String datasetPath, boolean isStream) {
        return HttpHeaderWriter.getHttpHeadersForXML(datasetPath, isStream);
    }

    protected void writeHeader() throws XMLStreamException {
        this.staxWriter.writeStartDocument("UTF-8", "1.0");
        this.staxWriter.writeCharacters("\n");
        this.staxWriter.writeStartElement("FeatureCollection");
        this.staxWriter.writeCharacters("\n");
    }

    protected void writeFooter() throws XMLStreamException {
        this.staxWriter.writeEndElement();
        this.staxWriter.writeCharacters("\n");
        this.staxWriter.writeEndDocument();
        this.staxWriter.close();
    }

    @Override
    public void write() throws Exception {
        this.writeHeader();
        for (DsgSubsetWriter writer : this.writers) {
            writer.write();
        }
        this.writeFooter();
    }
}

