/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.station;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import thredds.server.ncss.exception.FeaturesNotFoundException;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.view.dsg.DsgSubsetWriter;
import thredds.server.ncss.view.dsg.station.StationWriterUtils;
import ucar.ma2.StructureData;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.StationFeatureCollection;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.nc2.ft.point.PointCollectionIteratorFiltered;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.StationProfileFeatureImpl;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.IOIterator;
import ucar.unidata.geoloc.Station;

public abstract class AbstractStationProfileSubsetWriter
extends DsgSubsetWriter {
    protected final StationProfileFeatureCollection stationFeatureCollection;
    protected final List<StationFeature> wantedStations;
    protected boolean headerDone = false;

    public AbstractStationProfileSubsetWriter(FeatureDatasetPoint fdPoint, SubsetParams ncssParams) throws NcssException, IOException {
        this(fdPoint, ncssParams, 0);
    }

    public AbstractStationProfileSubsetWriter(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, int collectionIndex) throws NcssException, IOException {
        super(fdPoint, ncssParams);
        List featColList = fdPoint.getPointFeatureCollectionList();
        assert (featColList.size() > collectionIndex) : "Could not find feature collection.";
        assert (featColList.get(collectionIndex) instanceof StationProfileFeatureCollection) : "This class only deals with StationProfileFeatureCollections.";
        this.stationFeatureCollection = (StationProfileFeatureCollection)featColList.get(collectionIndex);
        this.wantedStations = StationWriterUtils.getStationsInSubset((StationFeatureCollection)this.stationFeatureCollection, ncssParams);
        if (this.wantedStations.isEmpty()) {
            throw new FeaturesNotFoundException("No stations found in subset.");
        }
    }

    protected abstract void writeHeader(StationProfileFeature var1) throws Exception;

    protected void writeProfileFeature(StationProfileFeature stn, ProfileFeature profileFeat) throws Exception {
        for (PointFeature feat : profileFeat) {
            assert (feat instanceof StationPointFeature) : "Expected StationPointFeature, not " + feat.getClass().toString();
            this.writeStationPointFeature(stn, (StationPointFeature)feat);
        }
    }

    protected abstract void writeStationPointFeature(StationProfileFeature var1, StationPointFeature var2) throws Exception;

    protected abstract void writeFooter() throws Exception;

    @Override
    public void write() throws Exception {
        StationProfileFeatureCollection subsettedStationFeatCol = this.stationFeatureCollection.subset(this.wantedStations);
        int count = 0;
        for (StationFeature profileFeat : subsettedStationFeatCol.getStationFeatures()) {
            assert (profileFeat instanceof StationProfileFeature) : "Expected StationProfileFeature, not " + profileFeat.getClass().toString();
            Object subsettedStationProfileFeat = (StationProfileFeature)profileFeat;
            if (this.wantedRange != null) {
                subsettedStationProfileFeat = subsettedStationProfileFeat.subset(this.wantedRange);
            }
            if (this.ncssParams.getTime() != null) {
                CalendarDate wantedTime = this.ncssParams.getTime();
                subsettedStationProfileFeat = new ClosestTimeStationProfileFeatureSubset((StationProfileFeatureImpl)subsettedStationProfileFeat, wantedTime);
            }
            count += this.writeStationProfileTimeSeriesFeature((StationProfileFeature)subsettedStationProfileFeat);
        }
        if (count == 0) {
            throw new NcssException("No features are in the requested subset");
        }
        this.writeFooter();
    }

    protected int writeStationProfileTimeSeriesFeature(StationProfileFeature stationProfileFeat) throws Exception {
        if (!this.headerDone) {
            this.writeHeader(stationProfileFeat);
            this.headerDone = true;
        }
        int count = 0;
        for (ProfileFeature profileFeat : stationProfileFeat) {
            this.writeProfileFeature(stationProfileFeat, profileFeat);
            ++count;
        }
        return count;
    }

    protected static class ClosestTimeStationProfileFeatureSubset
    extends StationProfileFeatureImpl {
        private final StationProfileFeature stationProfileFeat;
        private CalendarDate closestTime;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected ClosestTimeStationProfileFeatureSubset(StationProfileFeatureImpl stationFeat, CalendarDate wantedTime) throws IOException {
            super((Station)stationFeat, stationFeat.getTimeUnit(), stationFeat.getAltUnits(), -1);
            this.stationProfileFeat = stationFeat;
            CalendarDateRange cdr = stationFeat.getCalendarDateRange();
            if (cdr != null) {
                this.getInfo();
                this.info.setCalendarDateRange(cdr);
            }
            long smallestDiff = Long.MAX_VALUE;
            try (PointFeatureCollectionIterator iter = stationFeat.getPointFeatureCollectionIterator();){
                while (iter.hasNext()) {
                    ProfileFeature profileFeat = (ProfileFeature)iter.next();
                    PointFeatureIterator pfIter = profileFeat.getPointFeatureIterator();
                    try {
                        PointFeature point = pfIter.hasNext() ? pfIter.next() : null;
                        CalendarDate obsTime = point.getObservationTimeAsCalendarDate();
                        long diff = Math.abs(obsTime.getMillis() - wantedTime.getMillis());
                        if (diff >= smallestDiff) continue;
                        this.closestTime = obsTime;
                        smallestDiff = diff;
                    }
                    finally {
                        if (pfIter == null) continue;
                        pfIter.close();
                    }
                }
                return;
            }
        }

        public List<CalendarDate> getTimes() {
            return null;
        }

        public ProfileFeature getProfileByDate(CalendarDate date) throws IOException {
            return null;
        }

        @Nonnull
        public StructureData getFeatureData() throws IOException {
            return this.stationProfileFeat.getFeatureData();
        }

        public IOIterator<PointFeatureCollection> getCollectionIterator() throws IOException {
            return this.getPointFeatureCollectionIterator();
        }

        public PointFeatureCollectionIterator getPointFeatureCollectionIterator() throws IOException {
            if (this.closestTime == null) {
                return this.stationProfileFeat.getPointFeatureCollectionIterator();
            }
            return new PointCollectionIteratorFiltered(this.stationProfileFeat.getPointFeatureCollectionIterator(), (PointFeatureCollectionIterator.Filter)new TimeFilter(this.closestTime));
        }

        protected static class TimeFilter
        implements PointFeatureCollectionIterator.Filter {
            private final CalendarDate wantedTime;

            protected TimeFilter(CalendarDate wantedTime) {
                this.wantedTime = wantedTime;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean filter(PointFeatureCollection pointFeatureCollection) {
                try (PointFeatureIterator iter = pointFeatureCollection.getPointFeatureIterator();){
                    PointFeature point;
                    PointFeature pointFeature = point = iter.hasNext() ? iter.next() : null;
                    if (point == null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    boolean bl = point.getObservationTimeAsCalendarDate().equals((Object)this.wantedTime);
                    return bl;
                }
                catch (IOException ex) {
                    return false;
                }
            }
        }
    }
}

