/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.station;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import thredds.server.ncss.exception.FeaturesNotFoundException;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.view.dsg.DsgSubsetWriter;
import thredds.server.ncss.view.dsg.station.StationWriterUtils;
import ucar.ma2.StructureData;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.PointIteratorFiltered;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.StationTimeSeriesFeatureImpl;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;

public abstract class AbstractStationSubsetWriter
extends DsgSubsetWriter {
    protected final StationTimeSeriesFeatureCollection stationFeatureCollection;
    protected final List<StationFeature> wantedStations;
    protected boolean headerDone = false;

    public AbstractStationSubsetWriter(FeatureDatasetPoint fdPoint, SubsetParams ncssParams) throws NcssException, IOException {
        this(fdPoint, ncssParams, 0);
    }

    public AbstractStationSubsetWriter(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, int collectionIndex) throws NcssException, IOException {
        super(fdPoint, ncssParams);
        List featColList = fdPoint.getPointFeatureCollectionList();
        assert (featColList.size() > collectionIndex) : "Could not find feature collection.";
        assert (featColList.get(collectionIndex) instanceof StationTimeSeriesFeatureCollection) : "This class only deals with StationTimeSeriesFeatureCollections.";
        this.stationFeatureCollection = (StationTimeSeriesFeatureCollection)featColList.get(collectionIndex);
        this.wantedStations = StationWriterUtils.getStationsInSubset((StationFeatureCollection)this.stationFeatureCollection, ncssParams);
        if (this.wantedStations.isEmpty()) {
            throw new FeaturesNotFoundException("No stations found in subset.");
        }
    }

    protected abstract void writeHeader(StationPointFeature var1) throws Exception;

    protected abstract void writeStationPointFeature(StationPointFeature var1) throws Exception;

    protected abstract void writeFooter() throws Exception;

    @Override
    public void write() throws Exception {
        StationTimeSeriesFeatureCollection subsettedStationFeatCol = this.stationFeatureCollection.subsetFeatures(this.wantedStations);
        int count = 0;
        for (StationTimeSeriesFeature stationFeat : subsettedStationFeatCol) {
            Object subsettedStationFeat = stationFeat.subset(this.wantedRange);
            if (this.ncssParams.getTime() != null) {
                CalendarDate wantedTime = this.ncssParams.getTime();
                subsettedStationFeat = new ClosestTimeStationFeatureSubset((StationTimeSeriesFeatureImpl)subsettedStationFeat, wantedTime);
            }
            count += this.writeStationTimeSeriesFeature((StationTimeSeriesFeature)subsettedStationFeat);
        }
        if (count == 0) {
            throw new NcssException("No features are in the requested subset");
        }
        this.writeFooter();
    }

    protected int writeStationTimeSeriesFeature(StationTimeSeriesFeature stationFeat) throws Exception {
        int count = 0;
        for (PointFeature pointFeat : stationFeat) {
            assert (pointFeat instanceof StationPointFeature) : "Expected pointFeat to be a StationPointFeature, not a " + pointFeat.getClass().getSimpleName();
            if (!this.headerDone) {
                this.writeHeader((StationPointFeature)pointFeat);
                this.headerDone = true;
            }
            this.writeStationPointFeature((StationPointFeature)pointFeat);
            ++count;
        }
        return count;
    }

    protected static class ClosestTimeStationFeatureSubset
    extends StationTimeSeriesFeatureImpl {
        private final StationTimeSeriesFeature stationFeat;
        private CalendarDate closestTime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ClosestTimeStationFeatureSubset(StationTimeSeriesFeatureImpl stationFeat, CalendarDate wantedTime) throws IOException {
            super((StationFeature)stationFeat, stationFeat.getTimeUnit(), stationFeat.getAltUnits(), -1);
            this.stationFeat = stationFeat;
            CalendarDateRange cdr = stationFeat.getCalendarDateRange();
            if (cdr != null) {
                this.getInfo();
                this.info.setCalendarDateRange(cdr);
            }
            long smallestDiff = Long.MAX_VALUE;
            stationFeat.resetIteration();
            try {
                while (stationFeat.hasNext()) {
                    PointFeature pointFeat = stationFeat.next();
                    CalendarDate obsTime = pointFeat.getObservationTimeAsCalendarDate();
                    long diff = Math.abs(obsTime.getMillis() - wantedTime.getMillis());
                    if (diff >= smallestDiff) continue;
                    this.closestTime = obsTime;
                    smallestDiff = diff;
                }
            }
            finally {
                stationFeat.finish();
            }
        }

        @Nonnull
        public StructureData getFeatureData() throws IOException {
            return this.stationFeat.getFeatureData();
        }

        public PointFeatureIterator getPointFeatureIterator() throws IOException {
            if (this.closestTime == null) {
                return this.stationFeat.getPointFeatureIterator();
            }
            return new PointIteratorFiltered(this.stationFeat.getPointFeatureIterator(), (PointFeatureIterator.Filter)new TimeFilter(this.closestTime));
        }

        protected static class TimeFilter
        implements PointFeatureIterator.Filter {
            private final CalendarDate wantedTime;

            protected TimeFilter(CalendarDate wantedTime) {
                this.wantedTime = wantedTime;
            }

            public boolean filter(PointFeature pointFeature) {
                return pointFeature.getObservationTimeAsCalendarDate().equals((Object)this.wantedTime);
            }
        }
    }
}

