/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer2;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

public class RadarServerConfig {
    static ConcurrentHashMap<String, FileSystemProvider> fsproviders = new ConcurrentHashMap();

    public static List<RadarConfigEntry> readXML(String filename) {
        ArrayList<RadarConfigEntry> configs = new ArrayList<RadarConfigEntry>();
        SAXBuilder builder = new SAXBuilder();
        builder.setExpandEntities(false);
        File f = new File(filename);
        try {
            Document doc = builder.build(f);
            Element cat = doc.getRootElement();
            Namespace catNS = cat.getNamespace();
            Element topDS = cat.getChild("dataset", cat.getNamespace());
            for (Element dataset : topDS.getChildren("datasetScan", catNS)) {
                RadarConfigEntry conf = new RadarConfigEntry();
                configs.add(conf);
                Element collection = dataset.getChild("radarCollection", catNS);
                conf.dateParseRegex = collection.getAttributeValue("dateRegex");
                conf.dateFmt = collection.getAttributeValue("dateFormat");
                conf.layout = collection.getAttributeValue("layout");
                String crawlItems = collection.getAttributeValue("crawlItems");
                conf.crawlItems = crawlItems != null ? Integer.parseInt(crawlItems) : 5;
                Element meta = dataset.getChild("metadata", catNS);
                conf.name = dataset.getAttributeValue("name");
                conf.urlPath = dataset.getAttributeValue("path");
                conf.dataPath = RadarServerConfig.getPath(dataset.getAttributeValue("location"));
                conf.dataFormat = meta.getChild("dataFormat", catNS).getValue();
                conf.stationFile = meta.getChild("stationFile", catNS).getAttributeValue("path");
                conf.doc = meta.getChild("documentation", catNS).getValue();
                conf.timeCoverage = RadarServerConfig.readTimeCoverage(meta.getChild("timeCoverage", catNS));
                conf.spatialCoverage = RadarServerConfig.readGeospatialCoverage(meta.getChild("geospatialCoverage", catNS));
                Element variables = meta.getChild("variables", catNS);
                conf.vars = new ArrayList<RadarConfigEntry.VarInfo>();
                for (Element var : variables.getChildren("variable", catNS)) {
                    RadarConfigEntry.VarInfo inf = new RadarConfigEntry.VarInfo();
                    conf.vars.add(inf);
                    inf.name = var.getAttributeValue("name");
                    inf.vocabName = var.getAttributeValue("vocabulary_name");
                    inf.units = var.getAttributeValue("units");
                }
            }
        }
        catch (IOException | JDOMException e) {
            e.printStackTrace();
        }
        return configs;
    }

    private static Path getPath(String location) throws IOException {
        FileSystem fs;
        if (location.contains(":")) {
            URI uri = URI.create(location);
            if (uri.getPath().isEmpty()) {
                uri = URI.create(location.replace("//", "///"));
            }
            location = uri.getPath();
            fs = RadarServerConfig.getFS(uri);
        } else {
            fs = FileSystems.getDefault();
        }
        return fs.getPath(location, new String[0]);
    }

    private static FileSystem getFS(URI uri) throws IOException {
        FileSystem fs;
        try {
            fs = RadarServerConfig.getProvider(uri).getFileSystem(uri);
        }
        catch (ProviderNotFoundException e) {
            System.out.println("Provider not found: " + e.getMessage());
            System.out.println("Using default file system.");
            fs = FileSystems.getDefault();
        }
        return fs;
    }

    private static FileSystemProvider getProvider(URI uri) throws IOException {
        FileSystem fs;
        if (fsproviders.containsKey(uri.getScheme())) {
            return fsproviders.get(uri.getScheme());
        }
        try {
            fs = FileSystems.newFileSystem(uri, new HashMap(), Thread.currentThread().getContextClassLoader());
        }
        catch (FileSystemAlreadyExistsException e) {
            fs = FileSystems.getFileSystem(uri);
        }
        fsproviders.put(uri.getScheme(), fs.provider());
        return fs.provider();
    }

    protected static RadarConfigEntry.GeoInfo readGeospatialCoverage(Element gcElem) {
        if (gcElem == null) {
            return null;
        }
        Namespace defNS = gcElem.getNamespace();
        RadarConfigEntry.GeoInfo gi = new RadarConfigEntry.GeoInfo();
        gi.northSouth = RadarServerConfig.readGeospatialRange(gcElem.getChild("northsouth", defNS), "degrees_north");
        gi.eastWest = RadarServerConfig.readGeospatialRange(gcElem.getChild("eastwest", defNS), "degrees_east");
        gi.upDown = RadarServerConfig.readGeospatialRange(gcElem.getChild("updown", defNS), "m");
        return gi;
    }

    protected static RadarConfigEntry.RangeInfo readGeospatialRange(Element spElem, String defUnits) {
        if (spElem == null) {
            return null;
        }
        Namespace defNS = spElem.getNamespace();
        double start = RadarServerConfig.readDouble(spElem.getChild("start", defNS));
        double size = RadarServerConfig.readDouble(spElem.getChild("size", defNS));
        String units = spElem.getChildText("units", defNS);
        if (units == null) {
            units = defUnits;
        }
        RadarConfigEntry.RangeInfo ri = new RadarConfigEntry.RangeInfo();
        ri.units = units;
        ri.start = start;
        ri.size = size;
        return ri;
    }

    protected static double readDouble(Element elem) {
        if (elem == null) {
            return Double.NaN;
        }
        String text = elem.getText();
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    protected static DateRange readTimeCoverage(Element tElem) {
        if (tElem == null) {
            return null;
        }
        Namespace defNS = tElem.getNamespace();
        DateType start = RadarServerConfig.readDate(tElem.getChild("start", defNS));
        DateType end = RadarServerConfig.readDate(tElem.getChild("end", defNS));
        TimeDuration duration = RadarServerConfig.readDuration(tElem.getChild("duration", defNS));
        TimeDuration resolution = RadarServerConfig.readDuration(tElem.getChild("resolution", defNS));
        try {
            return new DateRange(start, end, duration, resolution);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected static DateType readDate(Element elem) {
        if (elem == null) {
            return null;
        }
        String format = elem.getAttributeValue("format");
        String type = elem.getAttributeValue("type");
        return RadarServerConfig.makeDateType(elem.getText(), format, type);
    }

    protected static DateType makeDateType(String text, String format, String type) {
        if (text == null) {
            return null;
        }
        try {
            return new DateType(text, format, type);
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected static TimeDuration readDuration(Element elem) {
        if (elem == null) {
            return null;
        }
        try {
            String text = elem.getText();
            return new TimeDuration(text);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static class RadarConfigEntry {
        public Path dataPath;
        public String name;
        public String urlPath;
        public String dataFormat;
        public String stationFile;
        public String doc;
        public String dateParseRegex;
        public String dateFmt;
        public String layout;
        public DateRange timeCoverage;
        public GeoInfo spatialCoverage;
        public int crawlItems;
        public List<VarInfo> vars;

        public static class VarInfo {
            public String name;
            public String vocabName;
            public String units;
        }

        public static class RangeInfo {
            public String units;
            public double start;
            public double size;
        }

        public static class GeoInfo {
            RangeInfo eastWest;
            RangeInfo northSouth;
            RangeInfo upDown;
        }
    }
}

