/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.reify;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import thredds.server.reify.LoadCommon;
import thredds.server.reify.Parameters;
import ucar.httpservices.HTTPUtil;

@Controller
@RequestMapping(value={"/upload", "/restrictedAccess/upload"})
public class UploadController
extends LoadCommon {
    protected static final boolean DEBUG = false;
    protected String uploaddirname = null;
    protected String uploadform = null;
    protected Parameters params = null;
    protected boolean issetup = false;

    public void doonce(HttpServletRequest req) throws LoadCommon.SendError {
        if (this.once) {
            return;
        }
        super.initOnce(req);
        if (this.uploaddir == null) {
            throw new LoadCommon.SendError(412, "Upload disabled");
        }
        this.uploaddirname = new File(this.uploaddir).getName();
        File upform = null;
        upform = this.tdsContext.getUploadForm();
        if (upform == null) {
            File root = this.tdsContext.getServletRootDirectory();
            upform = new File(root, "WEB-INF/upload.html");
        }
        try {
            this.uploadform = UploadController.loadForm(upform);
        }
        catch (IOException ioe) {
            throw new LoadCommon.SendError(412, ioe);
        }
    }

    public void setup(HttpServletRequest req, HttpServletResponse resp) throws LoadCommon.SendError {
        this.req = req;
        this.res = resp;
        if (!this.once) {
            this.doonce(req);
        }
        try {
            this.params = new Parameters(req);
        }
        catch (IOException ioe) {
            throw new LoadCommon.SendError(400, ioe);
        }
    }

    @RequestMapping(value={"**"}, method={RequestMethod.GET})
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            this.setup(req, res);
            switch (this.params.command) {
                case NONE: 
                case UPLOAD: {
                    this.sendForm("No files uploaded");
                    break;
                }
                case INQUIRE: {
                    String result = this.inquire();
                    this.sendOK(result);
                    break;
                }
                default: {
                    throw new LoadCommon.SendError(400, "Unknown command: " + this.params.command);
                }
            }
        }
        catch (LoadCommon.SendError se) {
            this.sendError(se);
        }
        catch (Exception e) {
            String msg = UploadController.getStackTrace(e);
            this.sendError(500, msg, e);
        }
    }

    @RequestMapping(value={"**"}, method={RequestMethod.POST})
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            this.setup(req, res);
            Collection parts = null;
            parts = req.getParts();
            if (parts.size() == 0) {
                this.sendError(400, "UploadController: Empty request");
                return;
            }
            String target = null;
            String filename = null;
            boolean overwrite = false;
            byte[] contents = null;
            for (Part part : parts) {
                String field = part.getName();
                String value = null;
                InputStream stream = part.getInputStream();
                if (field.equalsIgnoreCase("file")) {
                    filename = value = HTTPUtil.nullify((String)part.getSubmittedFileName());
                    contents = HTTPUtil.readbinaryfile((InputStream)stream);
                } else {
                    value = HTTPUtil.nullify((String)HTTPUtil.readtextfile((InputStream)stream));
                }
                if (field.equalsIgnoreCase("overwrite")) {
                    overwrite = value != null && value.equalsIgnoreCase("true");
                    continue;
                }
                if (!field.equalsIgnoreCase("target")) continue;
                target = value;
            }
            if (HTTPUtil.nullify(filename) == null) {
                this.sendError(400, "Empty filename");
                return;
            }
            if (target == null) {
                File t = new File(filename);
                target = t.getName();
            }
            StringBuilder buf = new StringBuilder();
            buf.append(HTTPUtil.canonicalpath((String)this.uploaddir));
            buf.append("/");
            buf.append(target);
            String abstarget = HTTPUtil.canonicalpath((String)buf.toString());
            File targetfile = new File(abstarget);
            File targetdir = targetfile.getParentFile();
            if (!targetdir.exists() && !targetdir.mkdirs()) {
                this.sendError(403, "Cannot create target parent directory: " + target);
            }
            if (targetfile.exists() && !overwrite) {
                this.sendError(403, "Target exists and replace was not specified: " + target);
            }
            if (targetfile.exists() && !targetfile.canWrite()) {
                this.sendError(403, "Target exists and is read-only: " + target);
            }
            HTTPUtil.writebinaryfile((byte[])contents, (File)targetfile);
            String msg = String.format("File upload succeeded: %s -> %s", filename, target);
            this.sendOK(msg);
        }
        catch (IOException ioe) {
            this.sendError(404, ioe.getMessage(), ioe);
        }
    }

    @Override
    protected String buildForm(String msg) {
        StringBuilder svc = new StringBuilder();
        svc.append(this.server);
        svc.append("/");
        svc.append(this.threddsname);
        String form = String.format(this.uploadform, svc.toString(), msg, this.server, this.uploaddirname);
        return form;
    }

    @Override
    protected void sendReply(int code, String msg) {
        super.sendReply(code, msg);
    }
}

