/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.admin;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import thredds.server.admin.DebugCommands;
import thredds.server.admin.HtmlWriting;
import thredds.util.ContentType;

@Controller
@RequestMapping(value={"/admin/debug"})
public class AdminDebugController {
    @Autowired
    DebugCommands debugCommands;
    @Autowired
    HtmlWriting htmlu;

    @RequestMapping(method={RequestMethod.GET})
    protected void showDebugPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(ContentType.html.getContentHeader());
        response.setHeader("Content-Description", "thredds_debug");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream((OutputStream)bos, false, "UTF-8");
        pw.println(this.htmlu.getHtmlDoctypeAndOpenTag());
        pw.println("<head>");
        pw.println("<title>THREDDS Debug</title>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
        pw.println(this.htmlu.getTdsPageCssLink());
        pw.println(this.htmlu.getGoogleTrackingContent());
        pw.println("</head>");
        pw.println("<body>");
        pw.println(this.htmlu.getOldStyleHeader());
        pw.println("<br><a href='dir/content/thredds/logs/'>Show TDS Logs</a>");
        pw.println("<br><a href='dir/content/tdm/'>Show TDM Logs</a>");
        pw.println("<br><a href='dir/logs/'>Show Tomcat Logs</a>");
        pw.println("<br><a href='dir/catalogs/'>Show Config Catalogs</a>");
        pw.println("<br><a href='spring/showControllers'>Show Spring Controllers</a>");
        pw.println("<h2>Debug Actions</h2>");
        pw.println("<pre>");
        String cmds = request.getQueryString();
        if (cmds == null || cmds.length() == 0) {
            this.showDebugActions(request, pw);
        } else {
            StringTokenizer tz = new StringTokenizer(cmds, ";");
            while (tz.hasMoreTokens()) {
                DebugCommands.Category dh;
                String cmd = tz.nextToken();
                String target = null;
                pw.println("Cmd= " + cmd);
                int pos = cmd.indexOf(47);
                String dhName = "General";
                if (pos > 0) {
                    dhName = cmd.substring(0, pos);
                    cmd = cmd.substring(pos + 1);
                }
                if ((pos = cmd.indexOf(61)) >= 0) {
                    target = cmd.substring(pos + 1);
                    cmd = cmd.substring(0, pos);
                }
                if ((dh = this.debugCommands.findCategory(dhName)) == null) {
                    pw.println(" Unknown Debug Category=" + dhName + "=");
                    continue;
                }
                DebugCommands.Action action = dh.actions.get(cmd);
                if (action == null) {
                    pw.println(" Unknown action=" + cmd + "=");
                    continue;
                }
                action.doAction(new DebugCommands.Event(request, response, pw, bos, target));
            }
        }
        pw.println("</pre></body></html>");
        response.setStatus(200);
        PrintWriter responsePS = response.getWriter();
        responsePS.write(bos.toString("UTF-8"));
        responsePS.flush();
    }

    private void showDebugActions(HttpServletRequest req, PrintStream pw) {
        for (DebugCommands.Category dh : this.debugCommands.getCategories()) {
            pw.println("<h2>" + dh.name + "</h2>");
            for (DebugCommands.Action act : dh.actions.values()) {
                if (act.desc == null) continue;
                String url = req.getRequestURI() + "?" + dh.name + "/" + act.name;
                pw.println("   <a href='" + url + "'>" + act.desc + "</a>");
            }
        }
    }
}

