/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ThreddsMetadata;
import thredds.server.catalogservice.DatasetContext;
import thredds.server.config.TdsContext;
import ucar.unidata.geoloc.LatLonRect;

class JsonLD {
    JsonLD() {
    }

    static String makeDatasetJsonLD(Dataset ds, DatasetContext dsContext, TdsContext tdsContext) {
        ThreddsMetadata.GeospatialCoverage gc;
        Map<String, Object> timeCoverage;
        JSONObject jo = new JSONObject();
        jo.put("@context", (Object)"https://schema.org/");
        jo.put("@type", (Object)"Dataset");
        Optional<String> name = dsContext.getDocumentation().stream().filter(doc -> doc.containsValue("title")).findFirst().map(found -> (String)found.get("inlineContent"));
        jo.put("name", (Object)name.orElse(dsContext.getName()));
        List<Map<String, String>> docs = dsContext.getDocumentation();
        List summary = dsContext.getDocumentation().stream().filter(doc -> doc.containsValue("summary")).map(found -> (String)found.get("inlineContent")).collect(Collectors.toList());
        if (!summary.isEmpty()) {
            jo.put("description", (Object)StringUtils.join(summary, (String)" "));
        }
        jo.put("url", (Object)dsContext.getCatUrl());
        jo.put("@id", (Object)dsContext.getCatUrl());
        List<Map<String, String>> kws = dsContext.getKeywords();
        if (kws.size() > 0) {
            JSONArray ja = new JSONArray();
            for (Map<String, String> kw : kws) {
                if (!kw.containsKey("text")) continue;
                ja.put((Object)kw.get("text"));
            }
            jo.put("keywords", (Object)ja);
        }
        String start = (timeCoverage = dsContext.getTimeCoverage()).containsKey("start") ? timeCoverage.get("start").toString() : "";
        String end = timeCoverage.containsKey("end") ? timeCoverage.get("end").toString() : "";
        JSONObject temporalCoverage = new JSONObject();
        if (!start.isEmpty() && !end.isEmpty()) {
            temporalCoverage.put("@value", (Object)String.format("%s/%s", start, end));
        } else if (!start.isEmpty()) {
            temporalCoverage.put("@value", (Object)String.format("%s", start));
        } else if (!end.isEmpty()) {
            temporalCoverage.put("@value", (Object)String.format("%s", end));
        }
        if (temporalCoverage.length() > 0) {
            jo.put("temporalCoverage", (Object)temporalCoverage);
        }
        if ((gc = ds.getGeospatialCoverage()) != null) {
            LatLonRect bbox = gc.getBoundingBox();
            String box = String.format("%s %s %s %s", bbox.getLowerLeftPoint().getLatitude(), bbox.getLowerLeftPoint().getLongitude(), bbox.getUpperRightPoint().getLatitude(), bbox.getUpperRightPoint().getLongitude());
            JSONObject spatialCoverage = new JSONObject();
            spatialCoverage.put("@type", (Object)"Place");
            JSONObject geo = new JSONObject();
            geo.put("@type", (Object)"GeoShape");
            geo.put("box", (Object)box);
            spatialCoverage.put("geo", (Object)geo);
            jo.put("spatialCoverage", (Object)spatialCoverage);
        }
        return jo.toString(2);
    }
}

