/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.core.StandardService;
import thredds.server.config.TdsContext;
import thredds.server.ncss.controller.NcssDiskCache;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.format.SupportedOperation;
import thredds.util.TdsPathUtils;

@Controller
@RequestMapping(value={"/ncss"})
public abstract class AbstractNcssController {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNcssController.class);
    @Autowired
    TdsContext tdsContext;
    @Autowired
    NcssDiskCache ncssDiskCache;
    private static final String[] endings = new String[]{"/dataset.xml", "/dataset.html", "/pointDataset.html", "/pointDataset.xml", "/datasetBoundaries.xml", "/datasetBoundaries.wkt", "/datasetBoundaries.json", "/station.xml"};

    public String getDatasetPath(HttpServletRequest req) {
        return TdsPathUtils.extractPath(req, this.getBase(), endings);
    }

    protected void setResponseHeaders(HttpServletResponse response, HttpHeaders httpHeaders) {
        Set keySet = httpHeaders.keySet();
        for (String key : keySet) {
            if (!httpHeaders.containsKey((Object)key)) continue;
            response.setHeader(key, (String)httpHeaders.get((Object)key).get(0));
        }
    }

    abstract String getBase();

    protected String buildDatasetUrl(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return this.tdsContext.getContextPath() + this.getBase() + path;
    }

    protected void handleValidationErrorMessage(HttpServletResponse response, int status, String errorMessage) {
        response.setStatus(status);
        try {
            PrintWriter pw = response.getWriter();
            pw.write(errorMessage);
            pw.flush();
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage());
        }
    }

    public static Element makeAcceptXML(SupportedOperation ops) {
        Element acceptList = new Element("AcceptList");
        for (SupportedFormat sf : ops.getSupportedFormats()) {
            Element accept = new Element("accept").addContent(sf.getFormatName()).setAttribute("displayName", sf.getFormatName());
            acceptList.addContent((Content)accept);
        }
        return acceptList;
    }

    public static List<String> makeAcceptList(SupportedOperation ops) {
        ArrayList<String> result = new ArrayList<String>();
        for (SupportedFormat sf : ops.getSupportedFormats()) {
            result.add(sf.getFormatName());
        }
        return result;
    }

    @ExceptionHandler(value={NcssException.class})
    public ResponseEntity<String> handle(NcssException e) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)e.getMessage(), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    public static String getDatasetPath(String path) {
        if (path.startsWith(StandardService.netcdfSubsetGrid.getBase())) {
            path = path.substring(StandardService.netcdfSubsetGrid.getBase().length());
        } else if (path.startsWith(StandardService.netcdfSubsetPoint.getBase())) {
            path = path.substring(StandardService.netcdfSubsetPoint.getBase().length());
        }
        for (String ending : endings) {
            if (!path.endsWith(ending)) continue;
            int len = path.length() - ending.length();
            path = path.substring(0, len);
            break;
        }
        return path;
    }
}

