/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.server.config.TdsContext;
import thredds.server.config.ThreddsConfig;
import thredds.server.wcs.WcsHandler;
import thredds.servlet.ServletUtil;
import ucar.nc2.util.DiskCache2;

@Controller
@RequestMapping(value={"/wcs"})
public class WCSController
implements InitializingBean {
    private static Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    @Autowired
    private TdsContext tdsContext;
    private DiskCache2 diskCache = null;
    private boolean allow = true;
    private boolean deleteImmediately = true;
    private boolean allowRemote = false;
    private long maxFileDownloadSize;
    private WcsHandler wcsHandler;

    public void afterPropertiesSet() throws ServletException {
    }

    @EventListener
    public void init(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getDisplayName().equals("Root WebApplicationContext")) {
            this.allow = ThreddsConfig.getBoolean("WCS.allow", true);
            logServerStartup.info("WCS:allow= " + this.allow);
            if (!this.allow) {
                logServerStartup.info("WCS service not enabled in threddsConfig.xml: ");
                return;
            }
            this.allowRemote = ThreddsConfig.getBoolean("WCS.allowRemote", false);
            this.deleteImmediately = ThreddsConfig.getBoolean("WCS.deleteImmediately", this.deleteImmediately);
            this.maxFileDownloadSize = ThreddsConfig.getBytes("WCS.maxFileDownloadSize", 1000000000L);
            String cache = ThreddsConfig.get("WCS.dir", new File(this.tdsContext.getThreddsDirectory(), "/cache/wcs/").getPath());
            File cacheDir = new File(cache);
            cacheDir.mkdirs();
            int scourSecs = ThreddsConfig.getSeconds("WCS.scour", 600);
            int maxAgeSecs = ThreddsConfig.getSeconds("WCS.maxAge", -1);
            maxAgeSecs = Math.max(maxAgeSecs, 300);
            scourSecs = Math.max(scourSecs, 300);
            this.diskCache = new DiskCache2(cache, false, maxAgeSecs / 60, scourSecs / 60);
            this.wcsHandler = new WcsHandler("1.0.0").setDeleteImmediately(this.deleteImmediately).setDiskCache(this.diskCache);
            logServerStartup.info("WCS service - init done - ");
        }
    }

    @RequestMapping(value={"**"})
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.allow) {
            res.sendError(403, "WCS service not supported");
            return;
        }
        String datasetURL = ServletUtil.getParameterIgnoreCase(req, "dataset");
        if (datasetURL != null && !this.allowRemote) {
            res.sendError(403, "WCS service not supported for remote datasets.");
            return;
        }
        String serviceParam = ServletUtil.getParameterIgnoreCase(req, "Service");
        String requestParam = ServletUtil.getParameterIgnoreCase(req, "Request");
        String acceptVersionsParam = ServletUtil.getParameterIgnoreCase(req, "AcceptVersions");
        String versionParam = ServletUtil.getParameterIgnoreCase(req, "Version");
        if (serviceParam == null || !serviceParam.equalsIgnoreCase("WCS")) {
            res.sendError(400, "GET request not a WCS KVP requestParam (missing or bad SERVICE parameter).");
            return;
        }
        this.wcsHandler.handleKVP(null, req, res);
    }

    public static enum Operation {
        GetCapabilities,
        DescribeCoverage,
        GetCoverage;

    }
}

