/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.core.ConfigCatalogHtmlWriter;
import thredds.core.TdsRequestedDataset;
import thredds.inventory.MFile;
import thredds.inventory.MFiles;
import thredds.util.ContentType;
import thredds.util.RequestForwardUtils;
import ucar.nc2.util.EscapeStrings;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;

public class ServletUtil {
    public static final Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    private static Logger log = LoggerFactory.getLogger(ServletUtil.class);

    public static String formFilename(String dirPath, String filePath) {
        if (dirPath == null || filePath == null) {
            return null;
        }
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return dirPath.endsWith("/") ? dirPath + filePath : dirPath + "/" + filePath;
    }

    public static void returnFile(HttpServlet servlet, String contentPath, String path, HttpServletRequest req, HttpServletResponse res, String contentType) throws IOException {
        String filename = ServletUtil.formFilename(contentPath, path);
        log.debug("returnFile(): returning file <" + filename + ">.");
        if (filename == null) {
            res.sendError(404);
            return;
        }
        if (filename.contains("..")) {
            res.sendError(403);
            return;
        }
        String upper = filename.toUpperCase();
        if (upper.contains("WEB-INF") || upper.contains("META-INF")) {
            res.sendError(403);
            return;
        }
        ServletUtil.returnFile(servlet, req, res, new File(filename), contentType);
    }

    public static void returnFile(HttpServlet servlet, HttpServletRequest req, HttpServletResponse res, File file, String contentType) throws IOException {
        if (file == null) {
            res.sendError(404);
            return;
        }
        if (!file.exists()) {
            res.sendError(404);
            return;
        }
        if (!file.isFile()) {
            res.sendError(400);
            return;
        }
        String filename = file.getPath();
        contentType = contentType == null ? ServletUtil.getContentType(filename, req.getServletContext()) : contentType;
        ServletUtil.returnFile(req, res, file, contentType);
    }

    private static String getContentType(String filename, ServletContext servletContext) {
        String contentType = servletContext.getMimeType(filename);
        if (contentType == null) {
            ContentType tdsSpecificContentType = ContentType.findContentTypeFromFilename((String)filename);
            contentType = tdsSpecificContentType != null ? tdsSpecificContentType.getContentHeader() : ContentType.binary.getContentHeader();
        }
        return contentType;
    }

    public static void returnFile(HttpServletRequest req, HttpServletResponse res, File file, String contentType) throws IOException {
        block15: {
            res.setContentType(contentType);
            res.addDateHeader("Last-Modified", file.lastModified());
            boolean isRangeRequest = ServletUtil.isRangeRequest(req.getHeader("Range"));
            long startPos = ServletUtil.getContentStartPosition(req.getHeader("Range"));
            long endPos = ServletUtil.getContentEndPosition(req.getHeader("Range"), file.length());
            long contentLength = endPos - startPos;
            ServletUtil.addContentLengthHeader(res, contentLength);
            String filename = file.getPath();
            res.addHeader("Accept-Ranges", "bytes");
            if (req.getMethod().equals("HEAD")) {
                return;
            }
            try {
                if (isRangeRequest) {
                    res.addHeader("Content-Range", "bytes " + startPos + "-" + (endPos - 1L) + "/" + file.length());
                    res.setStatus(206);
                    try (RandomAccessFile craf = RandomAccessFile.acquire((String)filename);){
                        IO.copyRafB((RandomAccessFile)craf, (long)startPos, (long)contentLength, (OutputStream)res.getOutputStream(), (byte[])new byte[60000]);
                        return;
                    }
                }
                ServletOutputStream out = res.getOutputStream();
                IO.copyFileB((File)file, (OutputStream)out, (int)60000);
            }
            catch (FileNotFoundException e) {
                log.error("returnFile(): FileNotFoundException= " + filename);
                if (!res.isCommitted()) {
                    res.sendError(404);
                }
            }
            catch (SocketException e) {
                log.info("returnFile(): SocketException sending file: " + filename + " " + e.getMessage());
            }
            catch (IOException e) {
                String eName = e.getClass().getName();
                if (eName.equals("org.apache.catalina.connector.ClientAbortException")) {
                    log.debug("returnFile(): ClientAbortException while sending file: " + filename + " " + e.getMessage());
                    return;
                }
                if (e.getMessage().startsWith("File transfer not complete")) {
                    log.debug("returnFile() " + e.getMessage());
                    return;
                }
                log.error("returnFile(): IOException (" + e.getClass().getName() + ") sending file ", (Throwable)e);
                if (res.isCommitted()) break block15;
                res.sendError(404, "Problem sending file: " + e.getMessage());
            }
        }
    }

    private static void addContentLengthHeader(HttpServletResponse res, long contentLength) {
        if (contentLength > Integer.MAX_VALUE) {
            res.addHeader("Content-Length", Long.toString(contentLength));
        } else {
            res.setContentLength((int)contentLength);
        }
    }

    private static boolean isRangeRequest(String rangeRequest) {
        if (rangeRequest != null) {
            return rangeRequest.indexOf("=") > 0 && rangeRequest.indexOf("-") > 0;
        }
        return false;
    }

    private static long getContentStartPosition(String rangeRequest) {
        boolean isRangeRequest = ServletUtil.isRangeRequest(rangeRequest);
        if (!isRangeRequest) {
            return 0L;
        }
        String startString = rangeRequest.substring(rangeRequest.indexOf("=") + 1, rangeRequest.indexOf("-"));
        return Long.parseLong(startString);
    }

    private static long getContentEndPosition(String rangeRequest, Long fileLength) {
        boolean isRangeRequest = ServletUtil.isRangeRequest(rangeRequest);
        if (!isRangeRequest) {
            return fileLength;
        }
        String endString = rangeRequest.substring(rangeRequest.indexOf("-") + 1);
        long endPosition = endString.length() > 0 ? Long.parseLong(endString) + 1L : fileLength;
        return Math.min(endPosition, fileLength);
    }

    public static void writeMFileToResponse(HttpServletRequest request, HttpServletResponse response, String requestPath) throws IOException {
        String location;
        String ncmlLocation = TdsRequestedDataset.getLocationFromNcml(requestPath);
        String string = location = ncmlLocation != null ? ncmlLocation : TdsRequestedDataset.getLocationFromRequestPath(requestPath);
        if (location == null) {
            response.sendError(404, "Could not find file with URL path: " + requestPath);
            return;
        }
        MFile file = MFiles.create((String)location);
        if (file == null) {
            response.sendError(404, "Could not find file with URL path: " + requestPath);
            return;
        }
        if (file.isDirectory() && !file.isZipFile()) {
            response.sendError(400, "Expected a file name instead of a directory for URL path: " + requestPath);
            return;
        }
        response.setContentType(ServletUtil.getContentType(requestPath, request.getServletContext()));
        response.addDateHeader("Last-Modified", file.getLastModified());
        response.addHeader("Accept-Ranges", "bytes");
        long startPosition = ServletUtil.getContentStartPosition(request.getHeader("Range"));
        long endPosition = ServletUtil.getContentEndPosition(request.getHeader("Range"), file.getLength());
        long contentLength = endPosition - startPosition;
        ServletUtil.addContentLengthHeader(response, contentLength);
        if (request.getMethod().equals("HEAD")) {
            return;
        }
        ServletOutputStream outputStream = response.getOutputStream();
        if (!ServletUtil.isRangeRequest(request.getHeader("Range"))) {
            file.writeToStream((OutputStream)outputStream);
            return;
        }
        response.addHeader("Content-Range", "bytes " + startPosition + "-" + (endPosition - 1L) + "/" + file.getLength());
        response.setStatus(206);
        file.writeToStream((OutputStream)outputStream, startPosition, contentLength);
    }

    public static void returnString(String contents, HttpServletResponse res) throws IOException {
        try {
            ServletOutputStream out = res.getOutputStream();
            IO.copy((InputStream)new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8)), (OutputStream)out);
        }
        catch (IOException e) {
            log.error(" IOException sending string: ", (Throwable)e);
            res.sendError(404, "Problem sending string: " + e.getMessage());
        }
    }

    public static int setResponseContentLength(HttpServletResponse response, String s) throws UnsupportedEncodingException {
        int length = s.getBytes(response.getCharacterEncoding()).length;
        response.setContentLength(length);
        return length;
    }

    public static String getReletiveURL(HttpServletRequest req) {
        return req.getContextPath() + req.getServletPath() + req.getPathInfo();
    }

    public static void forwardToCatalogServices(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String reqs = "catalog=" + ServletUtil.getReletiveURL(req);
        String query = req.getQueryString();
        if (query != null) {
            reqs = reqs + "&" + query;
        }
        log.info("forwardToCatalogServices(): request string = \"/catalog.html?" + reqs + "\"");
        RequestForwardUtils.forwardRequestRelativeToCurrentContext("/catalog.html?" + reqs, req, res);
    }

    public static void showSystemProperties(PrintStream out) {
        Properties sysp = System.getProperties();
        Set<String> propertyNames = sysp.stringPropertyNames();
        ArrayList<String> list = new ArrayList<String>(propertyNames);
        Collections.sort(list);
        out.println("System Properties:");
        for (String name : list) {
            String value = System.getProperty(name);
            out.println("  " + name + " = " + value);
        }
        out.println();
    }

    public static String getRequestServer(HttpServletRequest req) {
        return req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort();
    }

    public static String getRequestBase(HttpServletRequest req) {
        return req.getRequestURL().toString();
    }

    public static URI getRequestURI(HttpServletRequest req) {
        try {
            return new URI(ServletUtil.getRequestBase(req));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRequestPath(HttpServletRequest req) {
        StringBuilder buff = new StringBuilder();
        if (req.getServletPath() != null) {
            buff.append(req.getServletPath());
        }
        if (req.getPathInfo() != null) {
            buff.append(req.getPathInfo());
        }
        return buff.toString();
    }

    public static String getRequest(HttpServletRequest req) {
        String query = req.getQueryString();
        return ServletUtil.getRequestBase(req) + (String)(query == null ? "" : "?" + query);
    }

    public static String getParameterIgnoreCase(HttpServletRequest req, String paramName) {
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!s.equalsIgnoreCase(paramName)) continue;
            return req.getParameter(s);
        }
        return null;
    }

    public static String showRequestDetail(HttpServletRequest req) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Request Info\n");
        sbuff.append(" req.getServerName(): ").append(req.getServerName()).append("\n");
        sbuff.append(" req.getServerPort(): ").append(req.getServerPort()).append("\n");
        sbuff.append(" req.getContextPath:").append(req.getContextPath()).append("\n");
        sbuff.append(" req.getServletPath:").append(req.getServletPath()).append("\n");
        sbuff.append(" req.getPathInfo:").append(req.getPathInfo()).append("\n");
        sbuff.append(" req.getQueryString:").append(req.getQueryString()).append("\n");
        sbuff.append(" getQueryStringDecoded:").append(EscapeStrings.urlDecode((String)req.getQueryString())).append("\n");
        sbuff.append(" req.getRequestURI:").append(req.getRequestURI()).append("\n");
        sbuff.append(" getRequestBase:").append(ServletUtil.getRequestBase(req)).append("\n");
        sbuff.append(" getRequestServer:").append(ServletUtil.getRequestServer(req)).append("\n");
        sbuff.append(" getRequest:").append(ServletUtil.getRequest(req)).append("\n");
        sbuff.append("\n");
        sbuff.append(" req.getPathTranslated:").append(req.getPathTranslated()).append("\n");
        sbuff.append("\n");
        sbuff.append(" req.getScheme:").append(req.getScheme()).append("\n");
        sbuff.append(" req.getProtocol:").append(req.getProtocol()).append("\n");
        sbuff.append(" req.getMethod:").append(req.getMethod()).append("\n");
        sbuff.append("\n");
        sbuff.append(" req.getContentType:").append(req.getContentType()).append("\n");
        sbuff.append(" req.getContentLength:").append(req.getContentLength()).append("\n");
        sbuff.append(" req.getRemoteAddr():").append(req.getRemoteAddr());
        try {
            sbuff.append(" getRemoteHost():").append(InetAddress.getByName(req.getRemoteHost()).getHostName()).append("\n");
        }
        catch (UnknownHostException e) {
            sbuff.append(" getRemoteHost():").append(e.getMessage()).append("\n");
        }
        sbuff.append(" getRemoteUser():").append(req.getRemoteUser()).append("\n");
        sbuff.append("\n");
        sbuff.append("Request Parameters:\n");
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            String[] values = req.getParameterValues(name);
            if (values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                sbuff.append("  ").append(name).append("  (").append(i).append("): ").append(values[i]).append("\n");
            }
        }
        sbuff.append("\n");
        sbuff.append("Request Headers:\n");
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = req.getHeaders(name);
            if (values == null) continue;
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                sbuff.append("  ").append(name).append(": ").append(value).append("\n");
            }
        }
        sbuff.append(" ------------------\n");
        return sbuff.toString();
    }

    public static String showRequestHeaders(HttpServletRequest req) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Request Headers:\n");
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = req.getHeaders(name);
            if (values == null) continue;
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                sbuff.append("  ").append(name).append(": ").append(value).append("\n");
            }
        }
        return sbuff.toString();
    }

    public static void showSession(HttpServletRequest req, HttpServletResponse res, PrintStream out) {
        HttpSession session = req.getSession();
        Integer count = (Integer)session.getAttribute("snoop.count");
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        session.setAttribute("snoop.count", (Object)count);
        out.println(ConfigCatalogHtmlWriter.getHtmlDoctypeAndOpenTag());
        out.println("<HEAD><TITLE>SessionSnoop</TITLE></HEAD>");
        out.println("<BODY><H1>Session Snoop</H1>");
        out.println("You've visited this page " + count + (count == 1 ? " time." : " times."));
        out.println("<P>");
        out.println("<H3>Here is your saved session data:</H3>");
        Enumeration atts = session.getAttributeNames();
        while (atts.hasMoreElements()) {
            String name = (String)atts.nextElement();
            out.println(name + ": " + session.getAttribute(name) + "<BR>");
        }
        out.println("<H3>Here are some vital stats on your session:</H3>");
        out.println("Session id: " + session.getId() + " <I>(keep it secret)</I><BR>");
        out.println("New session: " + session.isNew() + "<BR>");
        out.println("Timeout: " + session.getMaxInactiveInterval());
        out.println("<I>(" + session.getMaxInactiveInterval() / 60 + " minutes)</I><BR>");
        out.println("Creation time: " + session.getCreationTime());
        out.println("<I>(" + new Date(session.getCreationTime()) + ")</I><BR>");
        out.println("Last access time: " + session.getLastAccessedTime());
        out.println("<I>(" + new Date(session.getLastAccessedTime()) + ")</I><BR>");
        out.println("Requested session ID from cookie: " + req.isRequestedSessionIdFromCookie() + "<BR>");
        out.println("Requested session ID from URL: " + req.isRequestedSessionIdFromURL() + "<BR>");
        out.println("Requested session ID valid: " + req.isRequestedSessionIdValid() + "<BR>");
        out.println("<H3>Test URL Rewriting</H3>");
        out.println("Click <A HREF=\"" + res.encodeURL(req.getRequestURI()) + "\">here</A>");
        out.println("to test that session tracking works via URL");
        out.println("rewriting even when cookies aren't supported.");
        out.println("</BODY></HTML>");
    }

    public static String showSecurity(HttpServletRequest req, String role) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Security Info\n");
        sbuff.append(" req.getRemoteUser(): ").append(req.getRemoteUser()).append("\n");
        sbuff.append(" req.getUserPrincipal(): ").append(req.getUserPrincipal()).append("\n");
        sbuff.append(" req.isUserInRole(").append(role).append("):").append(req.isUserInRole(role)).append("\n");
        sbuff.append(" ------------------\n");
        return sbuff.toString();
    }

    public static void showThreads(PrintStream pw) {
        Thread current = Thread.currentThread();
        ThreadGroup group = current.getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        ServletUtil.showThreads(pw, group, current);
    }

    private static void showThreads(PrintStream pw, ThreadGroup g, Thread current) {
        int nthreads = g.activeCount();
        pw.println("\nThread Group = " + g.getName() + " activeCount= " + nthreads);
        Thread[] tarray = new Thread[nthreads];
        int n = g.enumerate(tarray, false);
        for (int i = 0; i < n; ++i) {
            Thread thread = tarray[i];
            ClassLoader loader = thread.getContextClassLoader();
            String loaderName = loader == null ? "Default" : loader.getClass().getName();
            Thread.State state = thread.getState();
            long id = thread.getId();
            pw.print("   " + id + " " + thread.getName() + " " + state + " " + loaderName);
            if (thread == current) {
                pw.println(" **** CURRENT ***");
                continue;
            }
            pw.println();
        }
        int ngroups = g.activeGroupCount();
        ThreadGroup[] garray = new ThreadGroup[ngroups];
        int ng = g.enumerate(garray, false);
        for (int i = 0; i < ng; ++i) {
            ThreadGroup nested = garray[i];
            ServletUtil.showThreads(pw, nested, current);
        }
    }
}

