/*
 * Decompiled with CFR 0.152.
 */
package thredds.exp.enhancement.vectorize;

import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.exp.enhancement.vectorize.Vectorize;
import ucar.ma2.DataType;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.filter.Enhancement;
import ucar.nc2.filter.EnhancementProvider;

public class VectorDirection
extends Vectorize {
    private static Logger logger = LoggerFactory.getLogger(VectorDirection.class);
    public static final String ATTRIBUTE_NAME = "vectorize_dir";
    ReentrantLock lock = new ReentrantLock();

    public VectorDirection(Variable var) {
        super(var);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double convert(double num) {
        this.lock.lock();
        try {
            double u_val = this.uVar.read(this.indexToCoords((int)num), this.n_dimensional_array).getDouble(0);
            double v_val = this.vVar.read(this.indexToCoords((int)num), this.n_dimensional_array).getDouble(0);
            if (Math.sqrt(u_val * u_val + v_val * v_val) == 0.0) {
                double d = 0.0;
                return d;
            }
            double d = (Math.toDegrees(Math.atan2(u_val, v_val)) + 360.0 + (double)this.convention_offset) % 360.0;
            return d;
        }
        catch (Exception ex) {
            logger.error("error converting u and v to direction", (Throwable)ex);
            double d = Double.NaN;
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected String getAttributeName() {
        return ATTRIBUTE_NAME;
    }

    public static class Provider
    implements EnhancementProvider {
        public String getAttributeName() {
            return VectorDirection.ATTRIBUTE_NAME;
        }

        public boolean appliesTo(Set<NetcdfDataset.Enhance> enhance, DataType dt) {
            return dt.isNumeric();
        }

        public Enhancement create(VariableDS var) {
            return new VectorDirection((Variable)var);
        }
    }
}

