/*
 * Decompiled with CFR 0.152.
 */
package thredds.featurecollection.cache;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import java.util.Formatter;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.cache.DiskPersistedCache;
import thredds.inventory.MFile;
import ucar.nc2.ft.fmrc.GridDatasetInv;
import ucar.nc2.internal.dataset.ft.fmrc.InventoryCacheProvider;

public class GridInventoryDiskPersistedCache
implements InventoryCacheProvider {
    private static final Logger logger = LoggerFactory.getLogger(GridInventoryDiskPersistedCache.class);
    private static final int DEFAULT_ENTRIES = 1000;
    private static DiskPersistedCache<String, byte[]> cache;

    public static void init(Path cacheDir) throws IOException {
        GridInventoryDiskPersistedCache.init(cacheDir, 1000);
    }

    public static void init(Path cacheDir, int maxEntries) throws IOException {
        if (cache == null) {
            DiskPersistedCache.Builder builder = DiskPersistedCache.at((Path)cacheDir);
            builder.named("GridInventoryCache").maxInMemoryEntities((long)maxEntries);
            cache = builder.build();
        }
    }

    public static String name() {
        return cache == null ? "uninitialized" : cache.name();
    }

    public static void shutdown() {
        if (cache != null && cache.running()) {
            logger.info("Shutting down GridInventoryDiskPersistedCache...");
            cache.shutdown();
            logger.info("GridInventoryDiskPersistedCache shutdown");
        }
    }

    @Nullable
    public GridDatasetInv get(MFile mfile) throws IOException {
        String mfileLoc;
        byte[] xmlBytes;
        GridDatasetInv inv = null;
        if (cache != null && (xmlBytes = (byte[])cache.getOrDefault((Object)(mfileLoc = mfile.getPath()), null)) != null) {
            inv = GridDatasetInv.readXML((byte[])xmlBytes);
            if (inv.isXmlVersionCompatible()) {
                long fileModifiedSecs = mfile.getLastModified() / 1000L;
                long xmlModifiedSecs = inv.getLastModified() / 1000L;
                if (xmlModifiedSecs >= fileModifiedSecs) {
                    logger.debug("cache ok {} >= {} for {}", new Object[]{xmlModifiedSecs, fileModifiedSecs, mfileLoc});
                } else {
                    logger.info(" cache out of date {} < {} for {}. Removing cache entry.", new Object[]{xmlModifiedSecs, fileModifiedSecs, mfileLoc});
                    cache.remove((Object)mfileLoc);
                }
            } else {
                logger.error("GridDatasetInv xml version needs upgrade for {}. Removing cache entry.", (Object)mfileLoc);
                cache.remove((Object)mfileLoc);
            }
        }
        return inv;
    }

    public void put(MFile mfile, GridDatasetInv inventory) throws IOException {
        if (cache != null) {
            String xml = inventory.writeCompactXML(new Date(mfile.getLastModified()));
            cache.put((Object)mfile.getPath(), (Object)xml.getBytes(Charsets.UTF_8));
        }
    }

    public static void showCache(Formatter formatter) {
        if (cache == null) {
            formatter.format("%nFMRC GridInventoryCache: turned off%n", new Object[0]);
        } else {
            formatter.format("%nFMRC GridInventoryCache:%n", new Object[0]);
            formatter.format("DiskPersistedCache %s%n", cache.name());
            formatter.format("Level 1:%n", new Object[0]);
            cache.showL1Db(formatter);
            formatter.format("Level 2:%n", new Object[0]);
            cache.showL2Db(formatter, 10);
            formatter.format("%n", new Object[0]);
        }
    }

    static void resetCache() {
        GridInventoryDiskPersistedCache.shutdown();
        cache = null;
    }
}

