/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.core.TdsRequestedDataset;
import thredds.servlet.ServletUtil;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;

public class DatasetHandlerAdapter {
    private static Logger _log = LoggerFactory.getLogger(DatasetHandlerAdapter.class);

    public static NetcdfDataset openDataset(HttpServletRequest req, HttpServletResponse res, String datasetPath) throws Exception {
        NetcdfFile netcdfFile = null;
        NetcdfDataset dataset = null;
        if (datasetPath == null) {
            datasetPath = ServletUtil.getParameterIgnoreCase(req, "dataset");
            _log.debug("opendap datasetPath: " + datasetPath);
            try {
                dataset = NetcdfDatasets.openDataset((String)datasetPath);
            }
            catch (IOException e) {
                res.setStatus(404);
                _log.debug("Failed to open dataset <" + datasetPath + ">: " + e.getMessage());
            }
        } else {
            try {
                netcdfFile = TdsRequestedDataset.getNetcdfFile(req, res, datasetPath);
                _log.debug("datasetPath: " + datasetPath + " netcdfFile location: " + netcdfFile.getLocation());
                dataset = NetcdfDatasets.enhance((NetcdfFile)netcdfFile, (Set)NetcdfDataset.getDefaultEnhanceMode(), null);
            }
            catch (FileNotFoundException fnfe) {
                res.setStatus(404);
                _log.debug("Failed to get NetcdfFile <" + datasetPath + ">: " + fnfe.getMessage(), (Throwable)fnfe);
            }
            catch (IOException ioe) {
                res.setStatus(404);
                _log.debug("Failed to get NetcdfFile <" + datasetPath + "> using " + netcdfFile.getLocation() + ": " + ioe.getMessage(), (Throwable)ioe);
            }
        }
        return dataset;
    }

    public static void closeDataset(NetcdfDataset dataset) {
        if (dataset == null) {
            return;
        }
        try {
            dataset.close();
        }
        catch (IOException ioe) {
            _log.warn("Failed to properly close the dataset", (Throwable)ioe);
        }
    }
}

