/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.point;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.view.dsg.HttpHeaderWriter;
import thredds.server.ncss.view.dsg.point.AbstractPointSubsetWriter;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.util.Format;

public class PointSubsetWriterCSV
extends AbstractPointSubsetWriter {
    protected final PrintWriter writer;

    public PointSubsetWriterCSV(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, OutputStream out) throws NcssException {
        this(fdPoint, ncssParams, out, 0);
    }

    public PointSubsetWriterCSV(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, OutputStream out, int collectionIndex) throws NcssException {
        super(fdPoint, ncssParams, collectionIndex);
        this.writer = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    @Override
    public HttpHeaders getHttpHeaders(String datasetPath, boolean isStream) {
        return HttpHeaderWriter.getHttpHeadersForCSV(datasetPath, isStream);
    }

    @Override
    public void writeHeader(PointFeature pf) {
        this.writer.print("time,latitude[unit=\"degrees_north\"],longitude[unit=\"degrees_east\"]");
        for (VariableSimpleIF wantedVar : this.wantedVariables) {
            this.writer.print(",");
            this.writer.print(wantedVar.getShortName());
            if (wantedVar.getUnitsString() == null) continue;
            this.writer.print("[unit=\"" + wantedVar.getUnitsString() + "\"]");
        }
        this.writer.println();
    }

    @Override
    public void writePoint(PointFeature pointFeat) throws IOException {
        EarthLocation loc = pointFeat.getLocation();
        this.writer.print(CalendarDateFormatter.toDateTimeStringISO((CalendarDate)pointFeat.getObservationTimeAsCalendarDate()));
        this.writer.print(',');
        this.writer.print(Format.dfrac((double)loc.getLatitude(), (int)3));
        this.writer.print(',');
        this.writer.print(Format.dfrac((double)loc.getLongitude(), (int)3));
        StructureData structureData = pointFeat.getDataAll();
        for (VariableSimpleIF wantedVar : this.wantedVariables) {
            this.writer.print(',');
            Array dataArray = structureData.getArray(wantedVar.getShortName());
            this.writer.print(dataArray.toString().trim());
        }
        this.writer.println();
    }

    @Override
    public void writeFooter() {
        this.writer.flush();
    }
}

