/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.notebook;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.core.AllowedServices;
import thredds.core.CatalogManager;
import thredds.core.StandardService;
import thredds.core.TdsRequestedDataset;
import thredds.server.config.TdsContext;
import thredds.server.exception.ServiceNotAllowed;
import thredds.server.notebook.JupyterNotebookServiceCache;
import thredds.server.notebook.NotebookParamsBean;
import thredds.util.Constants;

@Controller
@RequestMapping(value={"/notebook"})
public class NotebookController {
    private final String DS_REPLACE_TEXT = "{{datasetName}}";
    private final String CAT_REPLACE_TEXT = "{{catUrl}}";
    @Autowired
    TdsContext tdsContext;
    @Autowired
    CatalogManager catalogManager;
    @Autowired
    AllowedServices allowedServices;
    @Autowired
    JupyterNotebookServiceCache jupyterNotebooks;

    @RequestMapping(value={"**"}, params={"filename"}, method={RequestMethod.GET})
    public void getNotebook(@RequestParam(value="filename") String filename, HttpServletRequest req, HttpServletResponse res, @Valid NotebookParamsBean params, BindingResult validationResult) throws ServiceNotAllowed, IOException, BindException, URISyntaxException {
        if (!this.allowedServices.isAllowed(StandardService.jupyterNotebook) || filename.isEmpty() || !this.validateRequestedFile(filename)) {
            throw new ServiceNotAllowed(StandardService.jupyterNotebook.toString());
        }
        if (validationResult.hasErrors()) {
            throw new BindException(validationResult);
        }
        File responseFile = this.getNotebookFile(filename);
        if (responseFile == null) {
            throw new FileNotFoundException(filename);
        }
        String catalogName = params.catalog;
        Dataset dataset = this.getDataset(catalogName, req);
        String fileContents = new String(Files.readAllBytes(Paths.get(responseFile.getAbsolutePath(), new String[0])));
        Object catUrlString = req.getRequestURL().toString();
        catUrlString = ((String)catUrlString).substring(0, ((String)catUrlString).indexOf(this.getBase())) + StandardService.catalogRemote.getBase() + catalogName;
        fileContents = fileContents.replace("{{datasetName}}", dataset.getName()).replace("{{catUrl}}", (CharSequence)catUrlString);
        res.setHeader("Content-Disposition", Constants.setContentDispositionValue((String)responseFile.getName()));
        res.setHeader("Content-Length", Integer.toString(fileContents.length()));
        String mimeType = "application/x-ipynb+json";
        res.setContentType(mimeType);
        res.getOutputStream().write(fileContents.getBytes());
        res.flushBuffer();
        res.getOutputStream().close();
        res.setStatus(200);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.GET})
    public void getNotebooksForDataset(HttpServletRequest req, HttpServletResponse res, @Valid NotebookParamsBean params, BindingResult validationResult) throws IllegalArgumentException, ServiceNotAllowed, IOException, URISyntaxException, BindException {
        if (!this.allowedServices.isAllowed(StandardService.jupyterNotebook)) {
            throw new ServiceNotAllowed(StandardService.jupyterNotebook.toString());
        }
        if (validationResult.hasErrors()) {
            throw new BindException(validationResult);
        }
        String catalogName = params.catalog;
        Dataset dataset = this.getDataset(catalogName, req);
        if (dataset == null) {
            throw new FileNotFoundException("Dataset with ID '" + new TdsRequestedDataset(req, this.getBase()).getPath() + "' not found in catalog '" + catalogName + "'.");
        }
        JSONArray notebooks = this.getNotebookParams(dataset);
        res.setContentType("application/json");
        res.setCharacterEncoding("UTF-8");
        res.getWriter().write(notebooks.toString());
        res.getWriter().flush();
        res.getWriter().close();
        res.setStatus(200);
    }

    protected String getBase() {
        return StandardService.jupyterNotebook.getBase();
    }

    private boolean validateRequestedFile(String filename) {
        if (!Arrays.asList(".py", ".ipynb").stream().anyMatch(ext -> filename.endsWith((String)ext))) {
            return false;
        }
        return !filename.contains("../");
    }

    private Dataset getDataset(String catalogName, HttpServletRequest req) throws URISyntaxException, IOException, IllegalArgumentException {
        if (catalogName == null) {
            throw new IllegalArgumentException("Argument 'catalog' cannot be null.");
        }
        String datasetId = new TdsRequestedDataset(req, this.getBase()).getPath();
        Catalog catalog = this.getCatalog(catalogName, req);
        return catalog.findDatasetByID(datasetId);
    }

    private Catalog getCatalog(String catalogName, HttpServletRequest req) throws URISyntaxException, IOException {
        Catalog catalog;
        String catalogReqBase = StandardService.catalogRemote.getBase();
        String baseUriString = req.getRequestURL().toString().replace(this.getBase(), catalogReqBase);
        baseUriString = baseUriString.substring(0, baseUriString.indexOf(catalogReqBase) + catalogReqBase.length());
        try {
            URI baseUri = new URI(baseUriString);
            catalog = this.catalogManager.getCatalog(catalogName, baseUri);
        }
        catch (URISyntaxException e) {
            String msg = "Bad URI syntax [" + baseUriString + "]: " + e.getMessage();
            throw new URISyntaxException(msg, e.getReason());
        }
        if (catalog == null) {
            throw new FileNotFoundException(baseUriString + catalogName);
        }
        return catalog;
    }

    private JSONArray getNotebookParams(Dataset ds) {
        List objs = this.jupyterNotebooks.getMappedNotebooks(ds).stream().map(nb -> nb.getParams()).collect(Collectors.toList());
        return new JSONArray(objs);
    }

    private File getNotebookFile(String filename) throws IOException {
        if (filename.isEmpty()) {
            return null;
        }
        File notebooksDir = new File(this.tdsContext.getThreddsDirectory(), "notebooks");
        if (notebooksDir.exists() && notebooksDir.isDirectory()) {
            File jupyterViewer = new File(notebooksDir, filename);
            if (!jupyterViewer.getCanonicalPath().startsWith(notebooksDir.getCanonicalPath())) {
                throw new AccessDeniedException(filename);
            }
            if (jupyterViewer.exists()) {
                return jupyterViewer;
            }
        }
        return null;
    }
}

