/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.util.LocalApiSigner;

@WebFilter(urlPatterns={"/local/*"})
public class LocalApiFilter
extends HttpFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger((String)"threddsServlet");
    private final String SIGNING_KEY = System.getProperty("tds.local.api.key", "");
    LocalApiSigner localApiSigner;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.log.debug("Filtering request to local API ");
        if (!(request instanceof HttpServletRequest)) {
            this.log.error("doFilter(): Not an HTTP request! How did this filter get here?");
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (!request.getRemoteAddr().equals(request.getLocalAddr())) {
            this.log.error("Request to local API from non-local address.");
            httpResponse.sendError(404);
            return;
        }
        if (!httpRequest.getMethod().equals("GET")) {
            this.log.error("Only GET requests to local API are supported.");
            httpResponse.sendError(404);
            return;
        }
        if (httpRequest.getHeader("X-TDS-Local-Api-Signature-V1") == null) {
            this.log.error("Local API request is not signed.");
            httpResponse.sendError(404);
            return;
        }
        if (!this.verifyRequest(httpRequest)) {
            this.initLocalApiSigner(true);
            if (!this.verifyRequest(httpRequest)) {
                this.log.error("Local API signature mismatch.");
                httpResponse.sendError(404);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void initLocalApiSigner(boolean reinit) {
        if (this.localApiSigner == null || reinit) {
            if (this.SIGNING_KEY.isEmpty()) {
                this.log.error("Local API cannot be used without key.");
                return;
            }
            Path tdmKey = Paths.get(this.SIGNING_KEY, new String[0]);
            try {
                this.localApiSigner = new LocalApiSigner(Files.readString(tdmKey));
            }
            catch (IOException e) {
                this.log.error("Local API cannot be used without key.", (Throwable)e);
            }
        }
    }

    private boolean verifyRequest(HttpServletRequest httpRequest) {
        String expected = httpRequest.getHeader("X-TDS-Local-Api-Signature-V1");
        if (expected == null) {
            this.log.error("Local API request missing {} header.", (Object)"X-TDS-Local-Api-Signature-V1");
            return false;
        }
        if (this.localApiSigner == null) {
            this.initLocalApiSigner(false);
        }
        String url = httpRequest.getRequestURI();
        if (httpRequest.getQueryString() != null) {
            url = String.format("%s?%s", url, httpRequest.getQueryString());
        }
        return this.localApiSigner.verifySignatureGet(url, expected);
    }
}

