/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import jakarta.annotation.Resource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import thredds.server.admin.DebugCommands;
import thredds.server.catalog.DataRoot;
import thredds.server.catalog.DataRootPathMatcher;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.catalog.tracker.DataRootExt;
import thredds.server.config.TdsContext;
import thredds.util.filesource.FileSource;
import ucar.nc2.util.AliasTranslator;

@Component
public class DataRootManager
implements InitializingBean {
    private static Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    private static final Logger logger = LoggerFactory.getLogger(DataRootManager.class);
    public static final boolean debug = true;
    @Autowired
    private TdsContext tdsContext;
    private DataRootPathMatcher dataRootPathMatcher;
    @Autowired
    private DebugCommands debugCommands;

    public static DataRootManager getInstance() {
        return new DataRootManager();
    }

    private DataRootManager() {
    }

    @Resource(name="dataRootLocationAliasExpanders")
    public void setDataRootLocationAliasExpanders(Map<String, String> aliases) {
        for (Map.Entry<String, String> entry : aliases.entrySet()) {
            AliasTranslator.addAlias((String)("${" + entry.getKey() + "}"), (String)entry.getValue());
        }
    }

    public void afterPropertiesSet() throws Exception {
        File file;
        FileSource fileSource = this.tdsContext.getPublicContentDirSource();
        if (fileSource != null && (file = fileSource.getFile("")) != null) {
            AliasTranslator.addAlias((String)"content", (String)StringUtils.cleanPath((String)file.getPath()));
        }
        this.makeDebugActions();
        startupLog.info("DataRootManager:" + AliasTranslator.size() + " aliases set ");
    }

    public synchronized void setDataRootPathMatcher(DataRootPathMatcher dataRootPathMatcher) {
        this.dataRootPathMatcher = dataRootPathMatcher;
    }

    public DataRootMatch findDataRootMatch(String spath) {
        DataRoot dataRoot = this.findDataRoot(spath);
        if (dataRoot == null) {
            return null;
        }
        DataRootMatch match = new DataRootMatch();
        match.rootPath = dataRoot.getPath();
        match.remaining = spath.substring(match.rootPath.length());
        if (match.remaining.startsWith("/")) {
            match.remaining = match.remaining.substring(1);
        }
        match.dirLocation = dataRoot.getDirLocation();
        match.dataRoot = dataRoot;
        return match;
    }

    private synchronized DataRoot findDataRoot(String spath) {
        if (spath == null) {
            return null;
        }
        if (spath.startsWith("/")) {
            spath = spath.substring(1);
        }
        return this.dataRootPathMatcher.findDataRoot(spath);
    }

    public String getLocationFromRequestPath(String reqPath) {
        DataRoot reqDataRoot = this.findDataRoot(reqPath);
        if (reqDataRoot == null) {
            return null;
        }
        return reqDataRoot.getFileLocationFromRequestPath(reqPath);
    }

    public synchronized void showRoots(Formatter f) {
        ArrayList list = new ArrayList(this.dataRootPathMatcher.getValues());
        Collections.sort(list, (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey()));
        for (Map.Entry entry : list) {
            f.format(" %s%n", entry.getValue());
        }
    }

    public synchronized List<FeatureCollectionRef> getFeatureCollections() {
        ArrayList<FeatureCollectionRef> result = new ArrayList<FeatureCollectionRef>();
        for (Map.Entry entry : this.dataRootPathMatcher.getValues()) {
            DataRootExt drootExt = (DataRootExt)entry.getValue();
            if (drootExt.getType() != DataRoot.Type.featureCollection) continue;
            DataRoot dataRoot = this.dataRootPathMatcher.convert2DataRoot(drootExt);
            if (dataRoot == null) {
                logger.error("Cant find dataRoot {} in DataRootPathMatcher", (Object)drootExt);
                continue;
            }
            result.add(dataRoot.getFeatureCollection());
        }
        return result;
    }

    public synchronized FeatureCollectionRef findFeatureCollection(String collectionName) {
        for (Map.Entry entry : this.dataRootPathMatcher.getValues()) {
            DataRootExt drootExt = (DataRootExt)entry.getValue();
            if (drootExt.getType() != DataRoot.Type.featureCollection || !drootExt.getName().equals(collectionName)) continue;
            DataRoot dataRoot = this.dataRootPathMatcher.convert2DataRoot(drootExt);
            return dataRoot.getFeatureCollection();
        }
        return null;
    }

    public void makeDebugActions() {
        DebugCommands.Category debugHandler = this.debugCommands.findCategory("Catalogs");
        DebugCommands.Action act = new DebugCommands.Action("showDataRoots", "Show data roots"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doAction(DebugCommands.Event e) {
                DataRootManager dataRootManager = DataRootManager.this;
                synchronized (dataRootManager) {
                    ArrayList list = new ArrayList(DataRootManager.this.dataRootPathMatcher.getValues());
                    Collections.sort(list, (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey()));
                    for (Map.Entry entry : list) {
                        DataRootExt ds = (DataRootExt)entry.getValue();
                        e.pw.printf(" <b>%s</b>", ds.getPath());
                        String url = DataRootManager.this.tdsContext.getContextPath() + "/admin/dir/dataDir/" + ds.getPath() + "/";
                        e.pw.printf(" for %s directory= <a href='%s'>%s</a>", ds.getType(), url, ds.getDirLocation());
                        if (ds.getRestrict() != null) {
                            e.pw.printf(" (restrict ='%s')", ds.getRestrict());
                        }
                        e.pw.printf("%n", new Object[0]);
                    }
                }
            }
        };
        debugHandler.addAction(act);
    }

    public static class DataRootMatch {
        public String rootPath;
        public String remaining;
        public String dirLocation;
        public DataRoot dataRoot;
    }
}

