/*
 * Decompiled with CFR 0.152.
 */
package thredds.exp.enhancement.vectorize;

import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.exp.enhancement.vectorize.Vectorize;
import ucar.ma2.DataType;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.filter.Enhancement;
import ucar.nc2.filter.EnhancementProvider;

public class VectorMagnitude
extends Vectorize {
    private static Logger logger = LoggerFactory.getLogger(VectorMagnitude.class);
    public static final String ATTRIBUTE_NAME = "vectorize_mag";
    ReentrantLock lock = new ReentrantLock();

    public VectorMagnitude(Variable var) {
        super(var);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double convert(double num) {
        this.lock.lock();
        try {
            double u_val = this.uVar.read(this.indexToCoords((int)num), this.n_dimensional_array).getDouble(0);
            double v_val = this.vVar.read(this.indexToCoords((int)num), this.n_dimensional_array).getDouble(0);
            double d = Math.sqrt(u_val * u_val + v_val * v_val);
            return d;
        }
        catch (Exception ex) {
            logger.error("error converting u and v to magnitude", (Throwable)ex);
            double d = Double.NaN;
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected String getAttributeName() {
        return ATTRIBUTE_NAME;
    }

    public static class Provider
    implements EnhancementProvider {
        public String getAttributeName() {
            return VectorMagnitude.ATTRIBUTE_NAME;
        }

        public boolean appliesTo(Set<NetcdfDataset.Enhance> enhance, DataType dt) {
            return dt.isNumeric();
        }

        public Enhancement create(VariableDS var) {
            return new VectorMagnitude((Variable)var);
        }
    }
}

