/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.admin;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import thredds.core.DataRootManager;
import thredds.server.config.TdsContext;
import thredds.servlet.ServletUtil;
import thredds.util.ContentType;
import thredds.util.TdsPathUtils;

@Controller
@RequestMapping(value={"/admin/log"}, method={RequestMethod.GET})
public class AdminLogController {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private DataRootManager matcher;

    @RequestMapping(value={"/dataroots.txt"})
    protected ResponseEntity<String> showRoots() throws Exception {
        Formatter f = new Formatter();
        this.matcher.showRoots(f);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Content-Type", ContentType.text.getContentHeader());
        return new ResponseEntity((Object)f.toString(), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"**"})
    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String path = TdsPathUtils.extractPath(req, "/admin/log");
        File file = null;
        if (path.equals("access/current")) {
            File dir = this.tdsContext.getTomcatLogDirectory();
            File[] files = dir.listFiles((dir1, name) -> name.startsWith("access"));
            if (files == null || files.length == 0) {
                res.sendError(404);
                return null;
            }
            List<File> fileList = Arrays.asList(files);
            Collections.sort(fileList);
            file = fileList.get(fileList.size() - 1);
        } else if (path.equals("access/")) {
            this.showFiles(this.tdsContext.getTomcatLogDirectory(), "access", res);
        } else {
            if (path.startsWith("access/")) {
                file = new File(this.tdsContext.getTomcatLogDirectory(), path.substring(7));
                ServletUtil.returnFile(req, res, file, "text/plain");
                return null;
            }
            if (path.equals("thredds/current")) {
                file = new File(this.tdsContext.getThreddsDirectory(), "logs/threddsServlet.log");
            } else if (path.equals("thredds/")) {
                this.showFiles(new File(this.tdsContext.getThreddsDirectory(), "logs"), "thredds", res);
            } else {
                if (path.startsWith("thredds/")) {
                    file = new File(this.tdsContext.getThreddsDirectory(), "logs/" + path.substring(8));
                    ServletUtil.returnFile(req, res, file, "text/plain");
                    return null;
                }
                PrintWriter pw = res.getWriter();
                pw.format("/log/access/current%n", new Object[0]);
                pw.format("/log/access/%n", new Object[0]);
                pw.format("/log/thredds/current%n", new Object[0]);
                pw.format("/log/thredds/%n", new Object[0]);
                pw.flush();
            }
        }
        if (file != null) {
            return new ModelAndView("threddsFileView", "file", (Object)file);
        }
        return null;
    }

    private void showFiles(File dir, String filter, HttpServletResponse res) throws IOException {
        File[] files = dir.listFiles((dir1, name) -> name.contains(filter));
        if (files == null || files.length == 0) {
            res.sendError(404);
            return;
        }
        List<File> fileList = Arrays.asList(files);
        Collections.sort(fileList);
        PrintWriter pw = res.getWriter();
        for (File f : fileList) {
            pw.format("%s %d%n", f.getName(), f.length());
        }
        pw.flush();
    }
}

