/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata;

import com.coverity.security.Escape;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.util.Formatter;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.ThreddsMetadata;
import thredds.core.TdsRequestedDataset;
import thredds.server.catalog.writer.ThreddsMetadataExtractor;
import thredds.server.metadata.MetadataRequestParameterBean;
import thredds.util.ContentType;
import thredds.util.TdsPathUtils;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.dt.GridDataset;

@Controller
@RequestMapping(value={"/metadata"})
public class MetadataController {
    @RequestMapping(value={"**"})
    public ResponseEntity<String> getMetadata(@Valid MetadataRequestParameterBean params, BindingResult result, HttpServletResponse res, HttpServletRequest req) throws Exception {
        if (result.hasErrors()) {
            throw new BindException(result);
        }
        String path = TdsPathUtils.extractPath(req, "metadata");
        try (GridDataset gridDataset = TdsRequestedDataset.getGridDataset(req, res, path);){
            String strResponse;
            if (gridDataset == null) {
                ResponseEntity<String> responseEntity = null;
                return responseEntity;
            }
            NetcdfFile ncfile = gridDataset.getNetcdfFile();
            String fileTypeS = ncfile.getFileTypeId();
            DataFormatType fileFormat = DataFormatType.getType((String)fileTypeS);
            if (fileFormat != null) {
                fileTypeS = fileFormat.toString();
            }
            ThreddsMetadata.VariableGroup vars = new ThreddsMetadataExtractor().extractVariables(fileTypeS, gridDataset);
            boolean wantXML = params.getAccept() != null && params.getAccept().equalsIgnoreCase("XML");
            HttpHeaders responseHeaders = new HttpHeaders();
            if (wantXML) {
                strResponse = this.writeXML(vars);
                responseHeaders.set("Content-Type", ContentType.xml.getContentHeader());
            } else {
                strResponse = this.writeHTML(vars);
                responseHeaders.set("Content-Type", ContentType.html.getContentHeader());
            }
            ResponseEntity responseEntity = new ResponseEntity((Object)strResponse, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
    }

    private String writeHTML(ThreddsMetadata.VariableGroup vars) {
        Formatter f = new Formatter();
        f.format("<h3>Variables:</h3>%n<ul>%n", new Object[0]);
        f.format("<em>Vocabulary</em> [", new Object[0]);
        if (vars.getVocabUri() != null) {
            ThreddsMetadata.UriResolved uri = vars.getVocabUri();
            f.format(" %s", uri.resolved.toString());
        }
        f.format(" %s ]%n<ul>%n", Escape.html((String)vars.getVocabulary()));
        List vlist = vars.getVariableList();
        if (vlist.size() > 0) {
            for (ThreddsMetadata.Variable v : vlist) {
                String units = v.getUnits() == null || v.getUnits().length() == 0 ? "" : " (" + v.getUnits() + ") ";
                f.format(" <li><strong>%s</strong>", Escape.html((String)(v.getName() + units)));
                if (v.getDescription() != null) {
                    f.format(" = <i>%s</i>", Escape.html((String)v.getDescription()));
                }
                if (v.getVocabularyName() != null && v.getVocabularyName().length() > 0) {
                    f.format(" = %s", Escape.html((String)v.getVocabularyName()));
                }
                f.format("%n", new Object[0]);
            }
        }
        f.format("</ul>%n", new Object[0]);
        return f.toString();
    }

    private String writeXML(ThreddsMetadata.VariableGroup vars) {
        Document doc = new Document();
        Element elem = new Element("variables", Catalog.defNS);
        doc.setRootElement(elem);
        if (vars.getVocabulary() != null) {
            elem.setAttribute("vocabulary", vars.getVocabulary());
        }
        if (vars.getVocabUri() != null) {
            elem.setAttribute("href", vars.getVocabUri().href, Catalog.xlinkNS);
        }
        List varList = vars.getVariableList();
        for (ThreddsMetadata.Variable v : varList) {
            elem.addContent((Content)this.writeVariable(v));
        }
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(doc);
    }

    private Element writeVariable(ThreddsMetadata.Variable v) {
        String id;
        String desc;
        Element elem = new Element("variable", Catalog.defNS);
        if (v.getName() != null) {
            elem.setAttribute("name", v.getName());
        }
        if (v.getDescription() != null && (desc = v.getDescription().trim()).length() > 0) {
            elem.setText(v.getDescription());
        }
        if (v.getVocabularyName() != null) {
            elem.setAttribute("vocabulary_name", v.getVocabularyName());
        }
        if (v.getUnits() != null) {
            elem.setAttribute("units", v.getUnits());
        }
        if ((id = v.getVocabularyId()) != null) {
            elem.setAttribute("vocabulary_id", id);
        }
        return elem;
    }
}

