/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import thredds.util.ContentType;

public enum SupportedFormat {
    CSV_STREAM("csv", true, false, ".csv", ContentType.csv, "csv_stream", "text/csv"),
    CSV_FILE("csv_file", false, false, ".csv", ContentType.csv, new String[0]),
    XML_STREAM("xml", true, false, ".xml", ContentType.xml, "xml_stream"),
    XML_FILE("xml_file", false, false, ".xml", ContentType.xml, new String[0]),
    NETCDF3("netcdf3", false, true, ".nc", ContentType.netcdf, "netcdf"),
    NETCDF4("netcdf4-classic", false, true, ".nc4", ContentType.netcdf, "netcdf4"),
    NETCDF4EXT("netcdf4ext", false, true, ".nc4", ContentType.netcdf, new String[0]),
    JSON("json", false, false, ".json", ContentType.json, "geojson"),
    WKT("wkt", false, false, ".txt", ContentType.text, new String[0]),
    WATERML2("waterml2", true, false, ".xml", ContentType.xml, "waterml2");

    private final List<String> aliases;
    private final String formatName;
    private final String fileSuffix;
    private final ContentType contentType;
    private final boolean isStream;
    private final boolean isBinary;

    private SupportedFormat(String formatName, boolean isStream, boolean isBinary, String fileSuffix, ContentType contentType, String ... aliases) {
        this.formatName = formatName;
        this.isStream = isStream;
        this.isBinary = isBinary;
        this.fileSuffix = fileSuffix;
        this.contentType = contentType;
        ArrayList aliasesList = new ArrayList();
        Collections.addAll(aliasesList, aliases);
        this.aliases = Collections.unmodifiableList(aliasesList);
    }

    public String getFormatName() {
        return this.formatName;
    }

    public String getMimeType() {
        return this.contentType.toString();
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public boolean isAlias(String want) {
        if (want.equalsIgnoreCase(this.formatName)) {
            return true;
        }
        for (String have : this.aliases) {
            if (!have.equalsIgnoreCase(want)) continue;
            return true;
        }
        return false;
    }

    public boolean isStream() {
        return this.isStream;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public boolean isText() {
        return !this.isBinary;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }
}

