/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.station;

import java.io.IOException;
import java.io.OutputStream;
import net.opengis.om.x20.OMObservationPropertyType;
import net.opengis.waterml.x20.CollectionDocument;
import net.opengis.waterml.x20.CollectionType;
import net.opengis.waterml.x20.DocumentMetadataPropertyType;
import org.apache.xmlbeans.XmlObject;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.view.dsg.HttpHeaderWriter;
import thredds.server.ncss.view.dsg.station.AbstractStationSubsetWriter;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ogc.MarshallingUtil;
import ucar.nc2.ogc.om.NcOMObservationPropertyType;
import ucar.nc2.ogc.waterml.NcDocumentMetadataPropertyType;

public class StationSubsetWriterWaterML
extends AbstractStationSubsetWriter {
    private final OutputStream out;
    private final CollectionDocument collectionDoc;
    private final CollectionType collection;

    public StationSubsetWriterWaterML(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, OutputStream out) throws NcssException, IOException {
        this(fdPoint, ncssParams, out, 0);
    }

    public StationSubsetWriterWaterML(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, OutputStream out, int collectionIndex) throws NcssException, IOException {
        super(fdPoint, ncssParams, collectionIndex);
        this.out = out;
        this.collectionDoc = CollectionDocument.Factory.newInstance();
        this.collection = this.collectionDoc.addNewCollection();
    }

    @Override
    public HttpHeaders getHttpHeaders(String datasetPath, boolean isStream) {
        return HttpHeaderWriter.getHttpHeadersForXML(datasetPath, isStream);
    }

    @Override
    protected void writeHeader(StationPointFeature stationPointFeat) throws Exception {
        MarshallingUtil.resetIds();
        String id = MarshallingUtil.createIdForType(CollectionType.class);
        this.collection.setId(id);
        NcDocumentMetadataPropertyType.initMetadata((DocumentMetadataPropertyType)this.collection.addNewMetadata());
    }

    @Override
    protected int writeStationTimeSeriesFeature(StationTimeSeriesFeature stationFeat) throws Exception {
        if (!this.headerDone) {
            this.writeHeader(null);
            this.headerDone = true;
        }
        for (VariableSimpleIF wantedVar : this.wantedVariables) {
            NcOMObservationPropertyType.initObservationMember((OMObservationPropertyType)this.collection.addNewObservationMember(), (StationTimeSeriesFeature)stationFeat, (VariableSimpleIF)wantedVar);
        }
        return 1;
    }

    @Override
    protected void writeStationPointFeature(StationPointFeature stationPointFeat) throws Exception {
        throw new UnsupportedOperationException("Method not used in " + String.valueOf(this.getClass()));
    }

    @Override
    protected void writeFooter() throws Exception {
        MarshallingUtil.writeObject((XmlObject)this.collectionDoc, (OutputStream)this.out, (boolean)true);
        this.out.flush();
    }
}

